/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceReactiveCircuitBreaker;

@Aspect
public class TraceReactiveCircuitBreakerFactoryAspect {
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;

    public TraceReactiveCircuitBreakerFactoryAspect(Tracer tracer, CurrentTraceContext currentTraceContext) {
        this.tracer = tracer;
        this.currentTraceContext = currentTraceContext;
    }

    @Around(value="execution(public * org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory.create(..))")
    public Object wrapFactory(ProceedingJoinPoint pjp) throws Throwable {
        ReactiveCircuitBreaker circuitBreaker = (ReactiveCircuitBreaker)pjp.proceed();
        return new TraceReactiveCircuitBreaker(circuitBreaker, this.tracer, this.currentTraceContext);
    }
}

