/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.async.SleuthAsyncSpan;

public class TraceRunnable
implements Runnable {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final Tracer tracer;
    private final Runnable delegate;
    private final Span parent;
    private final String spanName;

    public TraceRunnable(Tracer tracer, SpanNamer spanNamer, Runnable delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceRunnable(Tracer tracer, SpanNamer spanNamer, Runnable delegate, String name) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.parent = tracer.currentSpan();
        this.spanName = name != null ? name : spanNamer.name((Object)delegate, DEFAULT_SPAN_NAME);
    }

    @Override
    public void run() {
        AssertingSpan childSpan = SleuthAsyncSpan.ASYNC_RUNNABLE_SPAN.wrap(this.tracer.nextSpan(this.parent)).name(this.spanName);
        try (Tracer.SpanInScope ws = this.tracer.withSpan(childSpan.start());){
            this.delegate.run();
        }
        catch (Error | Exception e) {
            childSpan.error(e);
            throw e;
        }
        finally {
            childSpan.end();
        }
    }
}

