/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.rsocket;

import io.rsocket.RSocket;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.rsocket.RSocketRequesterAutoConfiguration;
import org.springframework.boot.autoconfigure.rsocket.RSocketServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.rsocket.server.RSocketServerCustomizer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.rsocket.SleuthRSocketProperties;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingRSocketConnectorConfigurer;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingRSocketServerCustomizer;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.rsocket.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={RSocket.class, RSocketStrategies.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@AutoConfigureBefore(value={RSocketRequesterAutoConfiguration.class, RSocketServerAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthRSocketProperties.class})
public class TraceRSocketAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    RSocketRequester.Builder rSocketRequesterBuilder(RSocketStrategies strategies, ObjectProvider<RSocketConnectorConfigurer> connectorConfigurerProvider) {
        RSocketRequester.Builder builder = RSocketRequester.builder().rsocketStrategies(strategies);
        connectorConfigurerProvider.forEach(arg_0 -> ((RSocketRequester.Builder)builder).rsocketConnector(arg_0));
        return builder;
    }

    private boolean containsZipkinPropagationType(List<String> types) {
        return types.stream().anyMatch(s -> s.equalsIgnoreCase("b3"));
    }

    @Bean
    RSocketConnectorConfigurer tracingRSocketConnectorConfigurer(Propagator propagator, Tracer tracer, @Value(value="${spring.sleuth.propagation.type:B3}") List<String> types) {
        return new TracingRSocketConnectorConfigurer(propagator, tracer, this.containsZipkinPropagationType(types));
    }

    @Bean
    RSocketServerCustomizer tracingRSocketServerCustomizer(Propagator propagator, Tracer tracer, @Value(value="${spring.sleuth.propagation.type:B3}") List<String> types) {
        return new TracingRSocketServerCustomizer(propagator, tracer, this.containsZipkinPropagationType(types));
    }
}

