/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.stats;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.TimedRequestContext;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.stats.LoadBalancerTags;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;

public class MicrometerStatsLoadBalancerLifecycle
implements LoadBalancerLifecycle<Object, Object, ServiceInstance> {
    private final MeterRegistry meterRegistry;
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;
    private final ConcurrentHashMap<ServiceInstance, AtomicLong> activeRequestsPerInstance = new ConcurrentHashMap();

    public MicrometerStatsLoadBalancerLifecycle(MeterRegistry meterRegistry, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
        this.meterRegistry = meterRegistry;
        this.loadBalancerFactory = loadBalancerFactory;
    }

    @Deprecated(forRemoval=true)
    public MicrometerStatsLoadBalancerLifecycle(MeterRegistry meterRegistry) {
        this(meterRegistry, new LoadBalancerClientFactory(new LoadBalancerClientsProperties()));
    }

    public boolean supports(Class requestContextClass, Class responseClass, Class serverTypeClass) {
        return ServiceInstance.class.isAssignableFrom(serverTypeClass);
    }

    public void onStart(Request<Object> request) {
    }

    public void onStartRequest(Request<Object> request, Response<ServiceInstance> lbResponse) {
        if (request != null && request.getContext() instanceof TimedRequestContext) {
            ((TimedRequestContext)request.getContext()).setRequestStartTime(System.nanoTime());
        }
        if (lbResponse == null || !lbResponse.hasServer()) {
            return;
        }
        ServiceInstance serviceInstance = (ServiceInstance)lbResponse.getServer();
        AtomicLong activeRequestsCounter = this.activeRequestsPerInstance.computeIfAbsent(serviceInstance, instance -> {
            AtomicLong createdCounter = new AtomicLong();
            Gauge.builder((String)"loadbalancer.requests.active", () -> createdCounter).tags(LoadBalancerTags.buildServiceInstanceTags(serviceInstance)).register(this.meterRegistry);
            return createdCounter;
        });
        activeRequestsCounter.incrementAndGet();
    }

    public void onComplete(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        Request lbRequest;
        ServiceInstance serviceInstance = null;
        Response loadBalancerResponse = completionContext.getLoadBalancerResponse();
        if (loadBalancerResponse != null) {
            serviceInstance = (ServiceInstance)loadBalancerResponse.getServer();
        }
        LoadBalancerProperties properties = serviceInstance != null ? this.loadBalancerFactory.getProperties(serviceInstance.getServiceId()) : this.loadBalancerFactory.getProperties(null);
        LoadBalancerTags loadBalancerTags = new LoadBalancerTags(properties);
        long requestFinishedTimestamp = System.nanoTime();
        if (CompletionContext.Status.DISCARD.equals((Object)completionContext.status())) {
            Counter.builder((String)"loadbalancer.requests.discard").tags(loadBalancerTags.buildDiscardedRequestTags(completionContext)).register(this.meterRegistry).increment();
            return;
        }
        AtomicLong activeRequestsCounter = this.activeRequestsPerInstance.get(serviceInstance);
        if (activeRequestsCounter != null) {
            activeRequestsCounter.decrementAndGet();
        }
        if ((lbRequest = completionContext.getLoadBalancerRequest()) == null) {
            return;
        }
        Object loadBalancerRequestContext = lbRequest.getContext();
        if (this.requestHasBeenTimed(loadBalancerRequestContext)) {
            if (CompletionContext.Status.FAILED.equals((Object)completionContext.status())) {
                Timer.builder((String)"loadbalancer.requests.failed").tags(loadBalancerTags.buildFailedRequestTags(completionContext)).register(this.meterRegistry).record(requestFinishedTimestamp - ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime(), TimeUnit.NANOSECONDS);
                return;
            }
            Timer.builder((String)"loadbalancer.requests.success").tags(loadBalancerTags.buildSuccessRequestTags(completionContext)).register(this.meterRegistry).record(requestFinishedTimestamp - ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime(), TimeUnit.NANOSECONDS);
        }
    }

    private boolean requestHasBeenTimed(Object loadBalancerRequestContext) {
        return loadBalancerRequestContext instanceof TimedRequestContext && ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime() != 0L;
    }
}

