/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

class CaffeineHints
implements RuntimeHintsRegistrar {
    private static final Log LOG = LogFactory.getLog(CaffeineHints.class);
    private static final String CAFFEINE_BOUNDED_LOCAL_CACHE_CLASS_NAME = "com.github.benmanes.caffeine.cache.BoundedLocalCache";
    private static final String CAFFEINE_CACHE_BASE_PACKAGE = "com/github/benmanes/caffeine/cache";
    private static final String CAFFEINE_NODE_CLASS_NAME = "com.github.benmanes.caffeine.cache.Node";

    CaffeineHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"com.github.benmanes.caffeine.cache.Caffeine", (ClassLoader)classLoader)) {
            return;
        }
        hints.reflection().registerType(TypeReference.of(Caffeine.class), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS})).registerType(TypeReference.of((String)CAFFEINE_BOUNDED_LOCAL_CACHE_CLASS_NAME), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS})).registerType(TypeReference.of((String)"com.github.benmanes.caffeine.cache.LocalCacheFactory"), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS})).registerType(TypeReference.of((String)CAFFEINE_NODE_CLASS_NAME), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS}));
        this.getCaffeineSubtypes().forEach(cacheType -> hints.reflection().registerType(TypeReference.of((String)cacheType), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS})));
    }

    private Set<String> getCaffeineSubtypes() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        try {
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Class.forName(CAFFEINE_BOUNDED_LOCAL_CACHE_CLASS_NAME)));
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Class.forName(CAFFEINE_NODE_CLASS_NAME)));
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"Could not get class for name: com.github.benmanes.caffeine.cache.BoundedLocalCache");
        }
        return provider.findCandidateComponents(CAFFEINE_CACHE_BASE_PACKAGE).stream().filter(Objects::nonNull).map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

