/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.configdata;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.configdata.ConfigDataPropertiesHolder;
import org.springframework.cloud.kubernetes.commons.configdata.KubernetesConfigDataResource;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;

public abstract class KubernetesConfigDataLocationResolver
implements ConfigDataLocationResolver<KubernetesConfigDataResource>,
Ordered {
    private static final boolean RETRY_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.retry.annotation.Retryable", null);

    protected final String getPrefix() {
        return "kubernetes:";
    }

    public final int getOrder() {
        return -1;
    }

    public final boolean isResolvable(@Nonnull ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(this.getPrefix()) && (CloudPlatform.KUBERNETES.isEnforced(context.getBinder()) || CloudPlatform.KUBERNETES.isDetected((Environment)new StandardEnvironment()));
    }

    public final List<KubernetesConfigDataResource> resolve(@Nonnull ConfigDataLocationResolverContext context, @Nonnull ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public final List<KubernetesConfigDataResource> resolveProfileSpecific(@Nonnull ConfigDataLocationResolverContext resolverContext, @Nonnull ConfigDataLocation location, @Nonnull Profiles profiles) throws ConfigDataLocationNotFoundException {
        ConfigDataPropertiesHolder properties = ConfigDataPropertiesHolder.of(resolverContext);
        HashMap<String, Object> kubernetesConfigData = new HashMap<String, Object>();
        kubernetesConfigData.put("spring.cloud.kubernetes.client.namespace", properties.clientProperties().namespace());
        String applicationName = (String)resolverContext.getBinder().bind("spring.application.name", String.class).orElse(null);
        if (applicationName != null) {
            kubernetesConfigData.put("spring.application.name", applicationName);
        }
        Environment environment = this.environment(kubernetesConfigData, profiles);
        KubernetesNamespaceProvider namespaceProvider = this.kubernetesNamespaceProvider(environment);
        this.registerBeans(resolverContext, properties, namespaceProvider);
        KubernetesConfigDataResource resource = new KubernetesConfigDataResource(location.isOptional(), profiles, environment);
        return List.of(resource);
    }

    protected abstract void registerBeans(ConfigDataLocationResolverContext var1, ConfigDataPropertiesHolder var2, KubernetesNamespaceProvider var3);

    protected final boolean isRetryEnabledForConfigMap(ConfigMapConfigProperties configMapProperties) {
        return RETRY_IS_PRESENT && configMapProperties != null && configMapProperties.retry().enabled() && configMapProperties.failFast();
    }

    protected final boolean isRetryEnabledForSecrets(SecretsConfigProperties secretsProperties) {
        return RETRY_IS_PRESENT && secretsProperties != null && secretsProperties.retry().enabled() && secretsProperties.failFast();
    }

    private KubernetesNamespaceProvider kubernetesNamespaceProvider(Environment environment) {
        return new KubernetesNamespaceProvider(environment);
    }

    private Environment environment(Map<String, Object> kubernetesConfigData, Profiles profiles) {
        MapPropertySource propertySource = new MapPropertySource("kubernetesConfigData", kubernetesConfigData);
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setActiveProfiles(profiles.getAccepted().toArray(new String[0]));
        return environment;
    }
}

