/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataFlattener;

public abstract class NamedSourceData {
    private static final Log LOG = LogFactory.getLog(NamedSourceData.class);

    public final SourceData compute(String sourceName, ConfigUtils.Prefix prefix, String target, boolean profileSources, boolean failFast, String namespace, String[] activeProfiles) {
        LinkedHashSet<String> sourceNamesToSearchFor = new LinkedHashSet<String>();
        sourceNamesToSearchFor.add(sourceName);
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            if (profileSources) {
                for (String activeProfile : activeProfiles) {
                    sourceNamesToSearchFor.add(sourceName + "-" + activeProfile);
                }
            }
            data = this.dataSupplier(sourceNamesToSearchFor);
            Map<String, Object> sourceDataForSourceName = data.data();
            LinkedHashSet<String> sourceNamesFound = data.names();
            String sortedNames = data.names().stream().sorted().collect(Collectors.joining("."));
            String sourceDataName = this.generateSourceName(target, sortedNames, namespace, activeProfiles);
            if (data.names().isEmpty()) {
                return this.emptySourceData(target, sourceName, namespace);
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DEFAULT.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.defaultFlattenedSourceData(sourceNamesFound, sourceDataForSourceName));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.KNOWN.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.prefixFlattenedSourceData(sourceNamesFound, sourceDataForSourceName, prefix.prefixProvider().get()));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DELAYED.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.nameFlattenedSourceData(sourceNamesFound, sourceDataForSourceName));
            }
            throw new IllegalArgumentException("Unsupported prefix: " + prefix);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failure in reading named sources");
            ConfigUtils.onException(failFast, e);
            String names = data.names().stream().sorted().collect(Collectors.joining("."));
            return new SourceData(this.generateSourceName(target, names, namespace, activeProfiles), Map.of("spring.cloud.k8s.error.reading.property.source", "true"));
        }
    }

    private SourceData emptySourceData(String target, String sourceName, String namespace) {
        String emptySourceName = ConfigUtils.sourceName(target, sourceName, namespace);
        LOG.debug((Object)("Will return empty source with name : " + emptySourceName));
        return SourceData.emptyRecord(emptySourceName);
    }

    protected String generateSourceName(String target, String sourceName, String namespace, String[] activeProfiles) {
        return ConfigUtils.sourceName(target, sourceName, namespace);
    }

    public abstract MultipleSourcesContainer dataSupplier(LinkedHashSet<String> var1);
}

