/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.gateway.server.webflux.filter.secure-headers")
public class SecureHeadersProperties {
    public static final String X_XSS_PROTECTION_HEADER = "X-Xss-Protection";
    public static final String X_XSS_PROTECTION_HEADER_DEFAULT = "1 ; mode=block";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER_DEFAULT = "max-age=631138519";
    public static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String X_FRAME_OPTIONS_HEADER_DEFAULT = "DENY";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER_DEFAULT = "nosniff";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String REFERRER_POLICY_HEADER_DEFAULT = "no-referrer";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    public static final String CONTENT_SECURITY_POLICY_HEADER_DEFAULT = "default-src 'self' https:; font-src 'self' https: data:; img-src 'self' https: data:; object-src 'none'; script-src https:; style-src 'self' https: 'unsafe-inline'";
    public static final String X_DOWNLOAD_OPTIONS_HEADER = "X-Download-Options";
    public static final String X_DOWNLOAD_OPTIONS_HEADER_DEFAULT = "noopen";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER = "X-Permitted-Cross-Domain-Policies";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER_DEFAULT = "none";
    public static final String PERMISSIONS_POLICY_HEADER = "Permissions-Policy";
    public static final String PERMISSIONS_POLICY_HEADER_OPT_IN_DEFAULT = "accelerometer=(), ambient-light-sensor=(), autoplay=(), battery=(), camera=(), cross-origin-isolated=(), display-capture=(), document-domain=(), encrypted-media=(), execution-while-not-rendered=(), execution-while-out-of-viewport=(), fullscreen=(), geolocation=(), gyroscope=(), keyboard-map=(), magnetometer=(), microphone=(), midi=(), navigation-override=(), payment=(), picture-in-picture=(), publickey-credentials-get=(), screen-wake-lock=(), sync-xhr=(), usb=(), web-share=(), xr-spatial-tracking=()";
    private String xssProtectionHeader = "1 ; mode=block";
    private String strictTransportSecurity = "max-age=631138519";
    private String frameOptions = "DENY";
    private String contentTypeOptions = "nosniff";
    private String referrerPolicy = "no-referrer";
    private String contentSecurityPolicy = "default-src 'self' https:; font-src 'self' https: data:; img-src 'self' https: data:; object-src 'none'; script-src https:; style-src 'self' https: 'unsafe-inline'";
    private String downloadOptions = "noopen";
    private String permittedCrossDomainPolicies = "none";
    private String permissionsPolicy = "accelerometer=(), ambient-light-sensor=(), autoplay=(), battery=(), camera=(), cross-origin-isolated=(), display-capture=(), document-domain=(), encrypted-media=(), execution-while-not-rendered=(), execution-while-out-of-viewport=(), fullscreen=(), geolocation=(), gyroscope=(), keyboard-map=(), magnetometer=(), microphone=(), midi=(), navigation-override=(), payment=(), picture-in-picture=(), publickey-credentials-get=(), screen-wake-lock=(), sync-xhr=(), usb=(), web-share=(), xr-spatial-tracking=()";
    private final Set<String> defaultHeaders;
    private Set<String> enabledHeaders = new HashSet<String>();
    private Set<String> disabledHeaders = new HashSet<String>();

    public SecureHeadersProperties() {
        this.defaultHeaders = Stream.of(X_XSS_PROTECTION_HEADER, STRICT_TRANSPORT_SECURITY_HEADER, X_FRAME_OPTIONS_HEADER, X_CONTENT_TYPE_OPTIONS_HEADER, REFERRER_POLICY_HEADER, CONTENT_SECURITY_POLICY_HEADER, X_DOWNLOAD_OPTIONS_HEADER, X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER).map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
    }

    public String getXssProtectionHeader() {
        return this.xssProtectionHeader;
    }

    public void setXssProtectionHeader(String xssProtectionHeader) {
        this.xssProtectionHeader = xssProtectionHeader;
    }

    public String getStrictTransportSecurity() {
        return this.strictTransportSecurity;
    }

    public void setStrictTransportSecurity(String strictTransportSecurity) {
        this.strictTransportSecurity = strictTransportSecurity;
    }

    public String getFrameOptions() {
        return this.frameOptions;
    }

    public void setFrameOptions(String frameOptions) {
        this.frameOptions = frameOptions;
    }

    public String getContentTypeOptions() {
        return this.contentTypeOptions;
    }

    public void setContentTypeOptions(String contentTypeOptions) {
        this.contentTypeOptions = contentTypeOptions;
    }

    public String getReferrerPolicy() {
        return this.referrerPolicy;
    }

    public void setReferrerPolicy(String referrerPolicy) {
        this.referrerPolicy = referrerPolicy;
    }

    public String getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public void setContentSecurityPolicy(String contentSecurityPolicy) {
        this.contentSecurityPolicy = contentSecurityPolicy;
    }

    public String getDownloadOptions() {
        return this.downloadOptions;
    }

    public void setDownloadOptions(String downloadOptions) {
        this.downloadOptions = downloadOptions;
    }

    public String getPermittedCrossDomainPolicies() {
        return this.permittedCrossDomainPolicies;
    }

    public void setPermittedCrossDomainPolicies(String permittedCrossDomainPolicies) {
        this.permittedCrossDomainPolicies = permittedCrossDomainPolicies;
    }

    public String getPermissionsPolicy() {
        return this.permissionsPolicy;
    }

    public void setPermissionsPolicy(String permissionsPolicy) {
        this.permissionsPolicy = permissionsPolicy;
    }

    public List<String> getDisable() {
        return this.disabledHeaders.stream().toList();
    }

    public void setDisable(List<String> disable) {
        if (disable != null) {
            this.disabledHeaders = disable.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
        }
    }

    public Set<String> getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setEnable(List<String> enable) {
        if (enable != null) {
            this.enabledHeaders = enable.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
        }
    }

    public Set<String> getDisabledHeaders() {
        return this.disabledHeaders;
    }

    public Set<String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public String toString() {
        return "SecureHeadersProperties{xssProtectionHeader='" + this.xssProtectionHeader + "', strictTransportSecurity='" + this.strictTransportSecurity + "', frameOptions='" + this.frameOptions + "', contentTypeOptions='" + this.contentTypeOptions + "', referrerPolicy='" + this.referrerPolicy + "', contentSecurityPolicy='" + this.contentSecurityPolicy + "', downloadOptions='" + this.downloadOptions + "', permittedCrossDomainPolicies='" + this.permittedCrossDomainPolicies + "', permissionsPolicy='" + this.permissionsPolicy + "', defaultHeaders=" + this.defaultHeaders + ", enable=" + this.enabledHeaders + ", disable=" + this.disabledHeaders + "}";
    }
}

