/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.netty.http.server.HttpServerResponse;

public class GRPCResponseHeadersFilter
implements HttpHeadersFilter,
Ordered {
    @Override
    public HttpHeaders filter(HttpHeaders headers, ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        HttpHeaders responseHeaders = response.getHeaders();
        if (this.isGRPC(exchange)) {
            String trailerHeaderValue = "grpc-status";
            String originalTrailerHeaderValue = responseHeaders.getFirst("Trailer");
            if (originalTrailerHeaderValue != null) {
                trailerHeaderValue = trailerHeaderValue + "," + originalTrailerHeaderValue;
            }
            responseHeaders.set("Trailer", trailerHeaderValue);
            ((HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse()).trailerHeaders(h -> h.set("grpc-status", (Object)"0"));
        }
        return headers;
    }

    private boolean isGRPC(ServerWebExchange exchange) {
        String contentTypeValue = exchange.getRequest().getHeaders().getFirst("Content-Type");
        return StringUtils.startsWithIgnoreCase((String)contentTypeValue, (String)"application/grpc");
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return HttpHeadersFilter.Type.RESPONSE.equals((Object)type);
    }

    public int getOrder() {
        return 0;
    }
}

