/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.function.Consumer;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.support.Configurable;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;

@FunctionalInterface
public interface GatewayFilterFactory<C>
extends ShortcutConfigurable,
Configurable<C> {
    public static final String NAME_KEY = "name";
    public static final String VALUE_KEY = "value";

    default public GatewayFilter apply(String routeId, Consumer<C> consumer) {
        C config = this.newConfig();
        consumer.accept(config);
        return this.apply(routeId, config);
    }

    default public GatewayFilter apply(Consumer<C> consumer) {
        C config = this.newConfig();
        consumer.accept(config);
        return this.apply(config);
    }

    @Override
    default public Class<C> getConfigClass() {
        throw new UnsupportedOperationException("getConfigClass() not implemented");
    }

    @Override
    default public C newConfig() {
        throw new UnsupportedOperationException("newConfig() not implemented");
    }

    public GatewayFilter apply(C var1);

    default public GatewayFilter apply(String routeId, C config) {
        if (config instanceof HasRouteId) {
            HasRouteId hasRouteId = (HasRouteId)config;
            hasRouteId.setRouteId(routeId);
        }
        return this.apply(config);
    }

    default public String name() {
        return NameUtils.normalizeFilterFactoryName(this.getClass());
    }
}

