/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public interface HttpHeadersFilter {
    public static HttpHeaders filterRequest(List<HttpHeadersFilter> filters, ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        return HttpHeadersFilter.filter(filters, headers, exchange, Type.REQUEST);
    }

    public static HttpHeaders filter(List<HttpHeadersFilter> filters, HttpHeaders input, ServerWebExchange exchange, Type type) {
        HttpHeaders response = input;
        if (filters != null) {
            HttpHeaders reduce = filters.stream().filter(headersFilter -> headersFilter.supports(type)).reduce(input, (headers, filter) -> filter.filter((HttpHeaders)headers, exchange), (httpHeaders, httpHeaders2) -> {
                httpHeaders.addAll((MultiValueMap)httpHeaders2);
                return httpHeaders;
            });
            return reduce;
        }
        return response;
    }

    public HttpHeaders filter(HttpHeaders var1, ServerWebExchange var2);

    default public boolean supports(Type type) {
        return type.equals((Object)Type.REQUEST);
    }

    public static enum Type {
        REQUEST,
        RESPONSE;

    }
}

