/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public final class FunctionTypeUtils {
    private static Log logger = LogFactory.getLog(FunctionTypeUtils.class);
    private static Type ROUTING_FUNCTION_TYPE = FunctionTypeUtils.discoverFunctionTypeFromClass(RoutingFunction.class);

    private FunctionTypeUtils() {
    }

    public static Type functionType(Type input, Type output) {
        return ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)input), ResolvableType.forType((Type)output)}).getType();
    }

    public static Type consumerType(Type input) {
        return ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)input)}).getType();
    }

    public static Type supplierType(Type output) {
        return ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)output)}).getType();
    }

    public static boolean isTypeCollection(Type type) {
        if (Collection.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)type))) {
            return true;
        }
        type = (type = FunctionTypeUtils.getGenericType((Type)type)) == null ? Object.class : type;
        Class rawType = type instanceof ParameterizedType ? FunctionTypeUtils.getRawType((Type)type) : (Class)type;
        return Collection.class.isAssignableFrom(rawType) || JsonNode.class.isAssignableFrom(rawType);
    }

    public static boolean isTypeMap(Type type) {
        if (Map.class.isAssignableFrom(FunctionTypeUtils.getRawType(type))) {
            return true;
        }
        Class rawType = (type = FunctionTypeUtils.getGenericType(type)) instanceof ParameterizedType ? FunctionTypeUtils.getRawType(type) : (Class)type;
        return Map.class.isAssignableFrom(rawType);
    }

    public static boolean isTypeArray(Type type) {
        return FunctionTypeUtils.getRawType(type).isArray();
    }

    public static boolean isJsonNode(Type type) {
        return FunctionTypeUtils.getRawType(type).isArray();
    }

    public static Type getGenericType(Type type) {
        if (FunctionTypeUtils.isPublisher((Type)type) || FunctionTypeUtils.isMessage((Type)type)) {
            type = FunctionTypeUtils.getImmediateGenericType((Type)type, 0);
        }
        if (type instanceof WildcardType) {
            type = Object.class;
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof WildcardType) {
            Object[] upperbounds = ((WildcardType)type).getUpperBounds();
            return ObjectUtils.isEmpty((Object[])upperbounds) ? Object.class : FunctionTypeUtils.getRawType((Type)upperbounds[0]);
        }
        return ResolvableType.forType((Type)type).getRawClass();
    }

    public static Method discoverFunctionalMethod(Class<?> pojoFunctionClass) {
        if (Supplier.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getAllDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("get")).findFirst().get();
        }
        if (Consumer.class.isAssignableFrom(pojoFunctionClass) || BiConsumer.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getAllDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("accept")).findFirst().get();
        }
        if (Function.class.isAssignableFrom(pojoFunctionClass) || BiFunction.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getAllDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("apply")).findFirst().get();
        }
        ArrayList methods = new ArrayList();
        ReflectionUtils.doWithMethods(pojoFunctionClass, method -> {
            if (method.getDeclaringClass() == pojoFunctionClass) {
                methods.add(method);
            }
        }, method -> !method.getDeclaringClass().isAssignableFrom(Object.class) && !method.isSynthetic() && !method.isBridge() && !method.isVarArgs());
        if (methods.size() > 1) {
            for (Method candidadteMethod : methods) {
                if (!candidadteMethod.getName().equals("apply") && !candidadteMethod.getName().equals("accept") && !candidadteMethod.getName().equals("get") && !candidadteMethod.getName().equals("invoke")) continue;
                return candidadteMethod;
            }
        }
        return CollectionUtils.isEmpty(methods) ? null : (Method)methods.get(0);
    }

    public static Type discoverFunctionTypeFromClass(Class<?> functionalClass) {
        if (KotlinDetector.isKotlinPresent()) {
            if (Function1.class.isAssignableFrom(functionalClass)) {
                ResolvableType kotlinType = ResolvableType.forClass(functionalClass).as(Function1.class);
                return GenericTypeResolver.resolveType((Type)kotlinType.getType(), functionalClass);
            }
            if (Function0.class.isAssignableFrom(functionalClass)) {
                ResolvableType kotlinType = ResolvableType.forClass(functionalClass).as(Function0.class);
                return GenericTypeResolver.resolveType((Type)kotlinType.getType(), functionalClass);
            }
        }
        Type typeToReturn = null;
        if (Function.class.isAssignableFrom(functionalClass)) {
            for (Type superInterface : functionalClass.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || !superInterface.toString().contains("KStream") || !ResolvableType.forType((Type)superInterface).getGeneric(new int[]{1}).isArray()) continue;
                return null;
            }
            ResolvableType functionType = ResolvableType.forClass(functionalClass).as(Function.class);
            typeToReturn = GenericTypeResolver.resolveType((Type)functionType.getType(), functionalClass);
        } else if (Consumer.class.isAssignableFrom(functionalClass)) {
            ResolvableType functionType = ResolvableType.forClass(functionalClass).as(Consumer.class);
            typeToReturn = GenericTypeResolver.resolveType((Type)functionType.getType(), functionalClass);
        } else if (Supplier.class.isAssignableFrom(functionalClass)) {
            ResolvableType functionType = ResolvableType.forClass(functionalClass).as(Supplier.class);
            typeToReturn = GenericTypeResolver.resolveType((Type)functionType.getType(), functionalClass);
        }
        return typeToReturn;
    }

    public static Type discoverFunctionTypeFromFunctionFactoryMethod(Class<?> clazz, String methodName) {
        return FunctionTypeUtils.discoverFunctionTypeFromFunctionFactoryMethod(ReflectionUtils.findMethod(clazz, (String)methodName));
    }

    public static Type discoverFunctionTypeFromFunctionFactoryMethod(Method method) {
        return method.getGenericReturnType();
    }

    public static Type discoverFunctionTypeFromFunctionMethod(Method functionMethod) {
        ResolvableType functionType;
        if (functionMethod == null) {
            return null;
        }
        Assert.isTrue((functionMethod.getName().equals("apply") || functionMethod.getName().equals("accept") || functionMethod.getName().equals("get") || functionMethod.getName().equals("invoke") ? 1 : 0) != 0, (String)("Only Supplier, Function or Consumer supported at the moment. Was " + functionMethod.getDeclaringClass()));
        if (functionMethod.getName().equals("apply") || functionMethod.getName().equals("invoke")) {
            ResolvableType output;
            ResolvableType input = ResolvableType.forMethodParameter((Method)functionMethod, (int)0);
            if (input.getType() instanceof TypeVariable) {
                input = ResolvableType.forClass(Object.class);
            }
            if ((output = ResolvableType.forMethodReturnType((Method)functionMethod)).getType() instanceof TypeVariable) {
                output = ResolvableType.forClass(Object.class);
            }
            functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{input, output});
        } else if (functionMethod.getName().equals("accept")) {
            ResolvableType parameterType = ResolvableType.forMethodParameter((Method)functionMethod, (int)0);
            if (parameterType.getType() instanceof TypeVariable) {
                parameterType = ResolvableType.forClass(Object.class);
            }
            functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{parameterType});
        } else {
            ResolvableType returnType = ResolvableType.forMethodReturnType((Method)functionMethod);
            if (returnType.getType() instanceof TypeVariable) {
                returnType = ResolvableType.forClass(Object.class);
            }
            functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{returnType});
        }
        return functionType.getType();
    }

    public static int getInputCount(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
        Type inputType;
        int inputCount;
        int n = inputCount = function.isSupplier() ? 0 : 1;
        if (inputCount > 0 && FunctionTypeUtils.isMulti(inputType = function.getInputType())) {
            inputCount = ((ParameterizedType)inputType).getActualTypeArguments().length;
        }
        return inputCount;
    }

    public static int getOutputCount(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
        Type outputType;
        int outputCount;
        int n = outputCount = function.isConsumer() ? 0 : 1;
        if (outputCount > 0 && FunctionTypeUtils.isMulti(outputType = function.getOutputType())) {
            outputCount = ((ParameterizedType)outputType).getActualTypeArguments().length;
        }
        return outputCount;
    }

    public static Type getComponentTypeOfInputType(Type functionType) {
        Type inputType = FunctionTypeUtils.getInputType(functionType);
        return FunctionTypeUtils.getImmediateGenericType(inputType, 0);
    }

    public static Type getComponentTypeOfOutputType(Type functionType) {
        Type inputType = FunctionTypeUtils.getOutputType(functionType);
        return FunctionTypeUtils.getImmediateGenericType(inputType, 0);
    }

    public static Type getInputType(Type functionType) {
        FunctionTypeUtils.assertSupportedTypes(functionType);
        if (FunctionTypeUtils.isSupplier(functionType)) {
            logger.debug((Object)"Supplier does not have input type, returning null as input type.");
            return null;
        }
        ResolvableType resolvableFunctionType = ResolvableType.forType((Type)functionType);
        if (FunctionTypeUtils.isFunction(functionType)) {
            return FunctionTypeUtils.extractInputType(resolvableFunctionType.as(Function.class).getGeneric(new int[]{0}));
        }
        if (FunctionTypeUtils.isConsumer(functionType)) {
            return FunctionTypeUtils.extractInputType(resolvableFunctionType.as(Consumer.class).getGeneric(new int[]{0}));
        }
        if (KotlinDetector.isKotlinPresent() && Function1.class.isAssignableFrom(FunctionTypeUtils.getRawType(functionType))) {
            return ResolvableType.forType((Type)FunctionTypeUtils.getImmediateGenericType(functionType, 1)).getType();
        }
        return Object.class;
    }

    private static Type extractInputType(ResolvableType resolvableInputType) {
        if (resolvableInputType.getType() instanceof TypeVariable) {
            return resolvableInputType.resolve(Object.class);
        }
        return resolvableInputType.getType();
    }

    public static Type discoverFunctionType(Object function, String functionName, GenericApplicationContext applicationContext) {
        ResolvableType resolvableType;
        if (function instanceof RoutingFunction) {
            return ROUTING_FUNCTION_TYPE;
        }
        if (function instanceof FunctionRegistration) {
            return ((FunctionRegistration)function).getType();
        }
        if (applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX)) {
            FunctionRegistration fr = (FunctionRegistration)applicationContext.getBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX, FunctionRegistration.class);
            return fr.getType();
        }
        functionName = FunctionTypeUtils.discoverBeanDefinitionNameByQualifier((ListableBeanFactory)applicationContext.getBeanFactory(), functionName);
        Type type = FunctionContextUtils.findType(applicationContext.getBeanFactory(), functionName);
        if (type == null || type instanceof Class) {
            String beanDefinitionName;
            boolean beanDefinitionExists = false;
            String functionBeanDefinitionName = FunctionTypeUtils.discoverDefinitionName(functionName, applicationContext);
            beanDefinitionExists = applicationContext.getBeanFactory().containsBeanDefinition(functionBeanDefinitionName);
            if (applicationContext.containsBean("&" + functionName)) {
                Class objectType = ((FactoryBean)applicationContext.getBean("&" + functionName, FactoryBean.class)).getObjectType();
                return FunctionTypeUtils.discoverFunctionTypeFromClass(objectType);
            }
            type = FunctionTypeUtils.discoverFunctionTypeFromClass(function.getClass());
            if (beanDefinitionExists) {
                Type t = FunctionTypeUtils.getImmediateGenericType(type, 0);
                if (t == null || t == Object.class) {
                    type = FunctionContextUtils.findType(applicationContext.getBeanFactory(), functionBeanDefinitionName);
                }
            } else if (!(type instanceof ParameterizedType) && StringUtils.hasText((String)(beanDefinitionName = FunctionTypeUtils.discoverBeanDefinitionNameByQualifier((ListableBeanFactory)applicationContext.getBeanFactory(), functionName)))) {
                type = FunctionContextUtils.findType(applicationContext.getBeanFactory(), beanDefinitionName);
            }
        } else if (type instanceof ParameterizedType && FactoryBean.class.isAssignableFrom((resolvableType = ResolvableType.forType((Type)type)).toClass())) {
            return resolvableType.getGeneric(new int[]{0}).getType();
        }
        return type;
    }

    public static String discoverBeanDefinitionNameByQualifier(ListableBeanFactory beanFactory, String qualifier) {
        String[] candidateBeans;
        for (String beanName : candidateBeans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, Object.class)) {
            if (!BeanFactoryAnnotationUtils.isQualifierMatch(qualifier::equals, (String)beanName, (BeanFactory)beanFactory)) continue;
            return beanName;
        }
        return null;
    }

    public static Type getOutputType(Type functionType) {
        Object outputType;
        ResolvableType resolvableOutputType;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        if (FunctionTypeUtils.isConsumer(functionType)) {
            logger.debug((Object)"Consumer does not have output type, returning null as output type.");
            return null;
        }
        ResolvableType resolvableFunctionType = ResolvableType.forType((Type)functionType);
        if (FunctionTypeUtils.isFunction(functionType)) {
            resolvableOutputType = resolvableFunctionType.as(Function.class);
        } else {
            if (KotlinDetector.isKotlinPresent() && Function1.class.isAssignableFrom(FunctionTypeUtils.getRawType(functionType))) {
                return ResolvableType.forType((Type)FunctionTypeUtils.getImmediateGenericType(functionType, 1)).getType();
            }
            resolvableOutputType = resolvableFunctionType.as(Supplier.class);
        }
        if (functionType instanceof Class) {
            ResolvableType genericClass0;
            ResolvableType genericClass1;
            Class functionTypeClass = (Class)functionType;
            outputType = FunctionTypeUtils.isFunction(functionType) ? ((outputType = (genericClass1 = resolvableOutputType.getGeneric(new int[]{1})).getType()) instanceof TypeVariable ? Object.class : GenericTypeResolver.resolveType((Type)outputType, (Class)functionTypeClass)) : ((outputType = (genericClass0 = resolvableOutputType.getGeneric(new int[]{0})).getType()) instanceof TypeVariable ? Object.class : GenericTypeResolver.resolveType((Type)outputType, (Class)functionTypeClass));
        } else if (functionType instanceof ParameterizedType) {
            Type genericType = FunctionTypeUtils.isSupplier(functionType) ? resolvableOutputType.getGeneric(new int[]{0}).getType() : resolvableOutputType.getGeneric(new int[]{1}).getType();
            outputType = GenericTypeResolver.resolveType((Type)genericType, FunctionTypeUtils.getRawType(functionType));
        } else {
            outputType = resolvableOutputType.getType();
        }
        return outputType instanceof TypeVariable ? Object.class : outputType;
    }

    public static Type getImmediateGenericType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    public static boolean isPublisher(Type type) {
        return FunctionTypeUtils.isFlux(type) || FunctionTypeUtils.isMono(type);
    }

    public static boolean isFlux(Type type) {
        return FunctionTypeUtils.getRawType(type) == Flux.class;
    }

    public static boolean isCollectionOfMessage(Type type) {
        if (FunctionTypeUtils.isMessage(type) && FunctionTypeUtils.isTypeCollection(type)) {
            return FunctionTypeUtils.isMessage(FunctionTypeUtils.getImmediateGenericType(type, 0));
        }
        return false;
    }

    public static boolean isMessage(Type type) {
        if (FunctionTypeUtils.isPublisher(type)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        Class<?> resolveRawClass = FunctionTypeUtils.getRawType(type);
        if (type instanceof ParameterizedType && !Message.class.isAssignableFrom(resolveRawClass)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        if ((resolveRawClass = FunctionTypeUtils.getRawType(type)) == null) {
            return false;
        }
        return Message.class.isAssignableFrom(resolveRawClass);
    }

    public static boolean isOutputArray(Type functionType) {
        Type outputType = FunctionTypeUtils.getOutputType(functionType);
        return outputType instanceof GenericArrayType || outputType instanceof Class && ((Class)outputType).isArray();
    }

    public static boolean isSupplier(Type type) {
        return FunctionTypeUtils.isOfType(type, Supplier.class);
    }

    public static boolean isFunction(Type type) {
        return FunctionTypeUtils.isOfType(type, Function.class);
    }

    public static boolean isConsumer(Type type) {
        return FunctionTypeUtils.isOfType(type, Consumer.class);
    }

    public static boolean isMono(Type type) {
        return (type = FunctionTypeUtils.extractReactiveType(type)) == null ? false : type.getTypeName().startsWith("reactor.core.publisher.Mono");
    }

    public static boolean isMultipleArgumentType(Type type) {
        if (type != null) {
            if (ResolvableType.forType((Type)type).isArray()) {
                return false;
            }
            Class clazz = ResolvableType.forType((Type)type).getRawClass();
            return clazz.getName().startsWith("reactor.util.function.Tuple");
        }
        return false;
    }

    static Type fromFunctionMethod(Method functionalMethod) {
        Type[] parameterTypes = functionalMethod.getGenericParameterTypes();
        Type functionType = null;
        switch (parameterTypes.length) {
            case 0: {
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            case 1: {
                if (Void.class.isAssignableFrom(functionalMethod.getReturnType())) {
                    functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0)}).getType();
                    break;
                }
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0), ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Functional method: " + functionalMethod + " is not supported");
            }
        }
        return functionType;
    }

    private static boolean isMulti(Type type) {
        return type.getTypeName().startsWith("reactor.util.function.Tuple");
    }

    private static boolean isOfType(Type type, Class<?> cls) {
        if (type instanceof Class) {
            return cls.isAssignableFrom((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return FunctionTypeUtils.isOfType(((ParameterizedType)type).getRawType(), cls);
        }
        return false;
    }

    private static void assertSupportedTypes(Type type) {
        Class candidateType;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            Assert.isTrue((boolean)(type instanceof Class), (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
        }
        Assert.isTrue((Supplier.class.isAssignableFrom(candidateType = (Class)type) || KotlinDetector.isKotlinPresent() && (Function0.class.isAssignableFrom(candidateType) || Function1.class.isAssignableFrom(candidateType)) || Function.class.isAssignableFrom(candidateType) || Consumer.class.isAssignableFrom(candidateType) || FunctionRegistration.class.isAssignableFrom(candidateType) || IntConsumer.class.isAssignableFrom(candidateType) || IntSupplier.class.isAssignableFrom(candidateType) || IntFunction.class.isAssignableFrom(candidateType) || ToIntFunction.class.isAssignableFrom(candidateType) || LongConsumer.class.isAssignableFrom(candidateType) || LongSupplier.class.isAssignableFrom(candidateType) || LongFunction.class.isAssignableFrom(candidateType) || ToLongFunction.class.isAssignableFrom(candidateType) || DoubleConsumer.class.isAssignableFrom(candidateType) || DoubleSupplier.class.isAssignableFrom(candidateType) || DoubleFunction.class.isAssignableFrom(candidateType) || ToDoubleFunction.class.isAssignableFrom(candidateType) || type.getTypeName().startsWith("org.springframework.context.annotation.ConfigurationClassEnhancer") ? 1 : 0) != 0, (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
    }

    private static Type extractReactiveType(Type type) {
        if (type instanceof ParameterizedType && FunctionRegistration.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) && (type = FunctionTypeUtils.getImmediateGenericType(type, 0)) instanceof ParameterizedType) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return type;
    }

    private static String discoverDefinitionName(String functionDefinition, GenericApplicationContext applicationContext) {
        String[] aliases;
        for (String alias : aliases = applicationContext.getAliases(functionDefinition)) {
            if (!applicationContext.getBeanFactory().containsBeanDefinition(alias)) continue;
            return alias;
        }
        return functionDefinition;
    }
}

