/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.util.ClassUtils;

public final class JsonMasker {
    private static final Log logger = LogFactory.getLog(JsonMasker.class);
    private static JsonMasker jsonMasker;
    private final JacksonMapper mapper;
    private final Set<String> keysToMask = JsonMasker.loadKeys();

    private JsonMasker() {
        this.mapper = new JacksonMapper(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT));
    }

    public static synchronized JsonMasker INSTANCE() {
        if (jsonMasker == null) {
            jsonMasker = new JsonMasker();
        }
        return jsonMasker;
    }

    public static synchronized JsonMasker INSTANCE(Set<String> keysToMask) {
        JsonMasker.INSTANCE().addKeys(keysToMask);
        return jsonMasker;
    }

    public String[] getKeysToMask() {
        return this.keysToMask.toArray(new String[0]);
    }

    public String mask(Object json) {
        if (!JsonMapper.isJsonString(json)) {
            return (String)json;
        }
        Object map = this.mapper.fromJson(json, (Type)((Object)Object.class));
        return this.iterate(map);
    }

    private String iterate(Object json) {
        block4: {
            block3: {
                if (!(json instanceof Collection)) break block3;
                Collection arrayValue = (Collection)json;
                for (Object e : arrayValue) {
                    if (!(e instanceof Map)) continue;
                    Map mapElement = (Map)e;
                    for (Map.Entry<String, Object> entry : mapElement.entrySet()) {
                        this.doMask((String)entry.getKey(), entry);
                    }
                }
                break block4;
            }
            if (!(json instanceof Map)) break block4;
            Map mapElement = (Map)json;
            for (Map.Entry<String, Object> entry : mapElement.entrySet()) {
                this.doMask((String)entry.getKey(), entry);
            }
        }
        return new String(this.mapper.toJson(json), StandardCharsets.UTF_8);
    }

    private void doMask(String key, Map.Entry<String, Object> entry) {
        if (this.keysToMask.contains(key)) {
            entry.setValue("*******");
        } else if (entry.getValue() instanceof Map) {
            this.iterate(entry.getValue());
        } else if (entry.getValue() instanceof Collection) {
            this.iterate(entry.getValue());
        }
    }

    private static Set<String> loadKeys() {
        TreeSet<String> finalKeysToMask = new TreeSet<String>();
        try {
            Enumeration<URL> resources = ClassUtils.getDefaultClassLoader().getResources("META-INF/mask.keys");
            while (resources.hasMoreElements()) {
                URI uri = resources.nextElement().toURI();
                List<String> lines = Files.readAllLines(Path.of(uri));
                for (String line : lines) {
                    String[] keys = line.split(",");
                    for (int i = 0; i < keys.length; ++i) {
                        finalKeysToMask.add(keys[i].trim());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to load keys to mask. No keys will be masked", (Throwable)e);
        }
        return finalKeysToMask;
    }

    private void addKeys(Set<String> keys) {
        this.keysToMask.addAll(keys);
    }
}

