/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.wiremock.AutoConfigureWireMock;
import org.springframework.cloud.contract.wiremock.WireMockConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public final class WireMockTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log log = LogFactory.getLog(WireMockTestExecutionListener.class);

    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (this.applicationContextBroken(testContext) || this.wireMockConfigurationMissing(testContext) || this.annotationMissing(testContext)) {
            return;
        }
        if (!this.portIsFixed(testContext)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Re-registering default mappings");
            }
            this.wireMockConfig(testContext).initIfNotRunning();
            this.wireMockConfig(testContext).start();
        }
    }

    public void afterTestClass(TestContext testContext) {
        if (this.applicationContextBroken(testContext) || this.wireMockConfigurationMissing(testContext) || this.annotationMissing(testContext)) {
            return;
        }
        if (this.portIsFixed(testContext)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"You've used fixed ports for WireMock setup - will mark context as dirty. Please use random ports, as much as possible. Your tests will be faster and more reliable and this warning will go away");
            }
            testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resetting mappings for the next test to restart them. That's necessary when reusing the same context with new servers running on random ports");
            }
            this.wireMockConfig(testContext).reRegisterServerWithResetMappings();
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.applicationContextBroken(testContext) || this.wireMockConfigurationMissing(testContext) || this.annotationMissing(testContext)) {
            return;
        }
        WireMockConfiguration wireMockConfiguration = this.wireMockConfig(testContext);
        if (wireMockConfiguration.wireMock.isResetMappingsAfterEachTest()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resetting mappings for the next test.");
            }
            wireMockConfiguration.resetMappings();
        }
    }

    private boolean annotationMissing(TestContext testContext) {
        if (!TestContextAnnotationUtils.hasAnnotation((Class)testContext.getTestClass(), AutoConfigureWireMock.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No @AutoConfigureWireMock annotation found on [" + testContext.getTestClass() + "]. Skipping"));
            }
            return true;
        }
        return false;
    }

    private boolean wireMockConfigurationMissing(TestContext testContext) {
        boolean missing;
        boolean bl = missing = !this.testContext(testContext).containsBean(WireMockConfiguration.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("WireMockConfiguration is missing [" + missing + "]"));
        }
        return missing;
    }

    private ApplicationContext testContext(TestContext testContext) {
        return testContext.getApplicationContext();
    }

    private boolean applicationContextBroken(TestContext testContext) {
        try {
            testContext.getApplicationContext();
            return false;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Application context is broken due to", (Throwable)ex);
            }
            return true;
        }
    }

    private WireMockConfiguration wireMockConfig(TestContext testContext) {
        return (WireMockConfiguration)this.testContext(testContext).getBean(WireMockConfiguration.class);
    }

    private boolean portIsFixed(TestContext testContext) {
        WireMockConfiguration wireMockProperties = this.wireMockConfig(testContext);
        boolean httpPortDynamic = wireMockProperties.wireMock.getServer().isPortDynamic();
        boolean httpsPortDynamic = wireMockProperties.wireMock.getServer().isHttpsPortDynamic();
        if (log.isDebugEnabled()) {
            int httpPort = wireMockProperties.wireMock.getServer().getPort();
            int httpsPort = wireMockProperties.wireMock.getServer().getHttpsPort();
            log.debug((Object)("Http port [" + httpPort + "] dynamic [" + httpPortDynamic + "] https port [" + httpsPort + "] dynamic [" + httpsPortDynamic + "]"));
        }
        return !httpPortDynamic || !httpsPortDynamic;
    }
}

