/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamMessageBuilder;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;

class StreamInputDestinationMessageSender
implements MessageVerifierSender<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamInputDestinationMessageSender.class);
    private final ApplicationContext context;
    private final ContractVerifierStreamMessageBuilder builder = new ContractVerifierStreamMessageBuilder();

    StreamInputDestinationMessageSender(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination, YamlContract contract) {
        this.send(this.builder.create(payload, headers), destination, contract);
    }

    @Override
    public void send(Message<?> message, String destination, YamlContract contract) {
        try {
            InputDestination inputDestination = (InputDestination)this.context.getBean(InputDestination.class);
            inputDestination.send(message, destination);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to send a message [" + message + "] to a destination with name [" + destination + "]"), (Throwable)e);
            throw e;
        }
    }
}

