/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassDataForMethod;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.util.Assert;

class BodyReader {
    private static final Log log = LogFactory.getLog(BodyReader.class);
    private final GeneratedClassMetaData generatedClassMetaData;
    private final YamlContractConverter converter = new YamlContractConverter();

    BodyReader(GeneratedClassMetaData generatedClassMetaData) {
        this.generatedClassMetaData = generatedClassMetaData;
    }

    String readBytesFromFileString(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        String fileName = this.byteBodyToAFileForTestMethod(metadata, property, side);
        return "fileToBytes(this, \"" + fileName + "\")";
    }

    String readStringFromFileString(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        if (!Charset.defaultCharset().toString().equals(property.getCharset())) {
            return "new String(" + this.readBytesFromFileString(metadata, property, side) + ", \"" + property.getCharset() + "\")";
        }
        return "new String(" + this.readBytesFromFileString(metadata, property, side) + ")";
    }

    void storeContractAsYaml(SingleContractMetadata metadata) {
        Contract contract = metadata.getContract();
        Object contracts = this.converter.convertTo(Collections.singleton(contract));
        Map<String, byte[]> store = this.converter.store((List<YamlContract>)contracts);
        store.forEach((name, bytes) -> this.writeFileForBothIdeAndBuildTool(metadata, (byte[])bytes, (String)name));
    }

    private String byteBodyToAFileForTestMethod(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        GeneratedClassDataForMethod classDataForMethod = this.classDataForMethod(metadata);
        String newFileName = classDataForMethod.getMethodName() + "_" + side.name().toLowerCase(Locale.ROOT) + "_" + property.fileName();
        this.writeFileForBothIdeAndBuildTool(metadata, property.asBytes(), newFileName);
        return newFileName;
    }

    private GeneratedClassDataForMethod classDataForMethod(SingleContractMetadata metadata) {
        return new GeneratedClassDataForMethod(this.generatedClassMetaData.generatedClassData, metadata.methodName());
    }

    private void writeFileForBothIdeAndBuildTool(SingleContractMetadata metadata, byte[] bytes, String newFileName) {
        File newFile;
        GeneratedClassDataForMethod classDataForMethod = this.classDataForMethod(metadata);
        Path parent = classDataForMethod.testClassPath().getParent();
        if (parent == null) {
            parent = classDataForMethod.testClassPath();
        }
        if ((newFile = new File(parent.toFile(), newFileName)).exists()) {
            return;
        }
        try {
            Path path = newFile.toPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Writing file for [" + path + "] for body reading in generated test (for IDE)"));
            }
            Files.write(path, bytes, new OpenOption[0]);
            this.generatedTestResourcesFileBytes(bytes, newFile);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void generatedTestResourcesFileBytes(byte[] bytes, File newFile) throws IOException {
        Assert.notNull((Object)this.generatedClassMetaData.configProperties.getGeneratedTestSourcesDir(), (String)"No generated test sources directory set");
        Assert.notNull((Object)this.generatedClassMetaData.configProperties.getGeneratedTestResourcesDir(), (String)"No generated test resources directory set");
        Path path = this.generatedClassMetaData.configProperties.getGeneratedTestSourcesDir().toPath();
        Path relativePath = path.relativize(newFile.toPath());
        File newFileInGeneratedTestSources = new File(this.generatedClassMetaData.configProperties.getGeneratedTestResourcesDir(), relativePath.toString());
        newFileInGeneratedTestSources.getParentFile().mkdirs();
        Path generatedTestSourceFilePath = newFileInGeneratedTestSources.toPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing file for [" + generatedTestSourceFilePath + "] for body reading in generated test (Build tool)"));
        }
        Files.write(generatedTestSourceFilePath, bytes, new OpenOption[0]);
    }
}

