/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class XmlImports
implements Imports {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] IMPORTS = new String[]{"javax.xml.parsers.DocumentBuilder", "javax.xml.parsers.DocumentBuilderFactory", "org.w3c.dom.Document", "org.xml.sax.InputSource", "java.io.StringReader"};

    XmlImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        Arrays.stream(IMPORTS).forEach(s -> this.blockBuilder.addLineWithEnding("import " + s));
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.listOfFiles.stream().anyMatch(metadata -> metadata.getConvertedContractWithMetadata().stream().anyMatch(SingleContractMetadata::isXml));
    }
}

