/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="stubrunner")
public class StubMapperProperties {
    private Map<String, String> idsToServiceIds = new HashMap<String, String>();

    public Map<String, String> getIdsToServiceIds() {
        return this.idsToServiceIds;
    }

    public void setIdsToServiceIds(Map<String, String> idsToServiceIds) {
        this.idsToServiceIds = idsToServiceIds;
    }

    public String fromIvyNotationToId(String ivyNotation) {
        StubConfiguration stubConfiguration = new StubConfiguration(ivyNotation);
        String id = this.idsToServiceIds.get(ivyNotation);
        if (StringUtils.hasText((String)id)) {
            return id;
        }
        String groupAndArtifact = this.idsToServiceIds.get(stubConfiguration.getGroupId() + ":" + stubConfiguration.getArtifactId());
        if (StringUtils.hasText((String)groupAndArtifact)) {
            return groupAndArtifact;
        }
        return this.idsToServiceIds.get(stubConfiguration.getArtifactId());
    }

    public String fromServiceIdToIvyNotation(String serviceId) {
        for (Map.Entry<String, String> entry : this.idsToServiceIds.entrySet()) {
            if (!entry.getValue().equals(serviceId)) continue;
            return entry.getKey();
        }
        return null;
    }
}

