/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;

public class PathBodyMatcher
implements BodyMatcher {
    private String path;
    private MatchingTypeValue matchingTypeValue;

    PathBodyMatcher(String path, MatchingTypeValue matchingTypeValue) {
        this.path = path;
        this.matchingTypeValue = matchingTypeValue;
    }

    @Override
    public MatchingType matchingType() {
        return this.matchingTypeValue.getType();
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Object value() {
        return this.matchingTypeValue.getValue();
    }

    @Override
    public Integer minTypeOccurrence() {
        return this.matchingTypeValue.getMinTypeOccurrence();
    }

    @Override
    public Integer maxTypeOccurrence() {
        return this.matchingTypeValue.getMaxTypeOccurrence();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathBodyMatcher that = (PathBodyMatcher)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.matchingTypeValue, that.matchingTypeValue);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.matchingTypeValue);
    }

    public String toString() {
        return "PathBodyMatcher{path='" + this.path + "', matchingTypeValue=" + this.matchingTypeValue + "}";
    }
}

