/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.transport.http;

import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.util.ConfigUtils;

final class SslConfig {
    private static final String CIPHER_SUITES = "https.cipherSuites";
    private static final String PROTOCOLS = "https.protocols";
    final SSLContext context;
    final HostnameVerifier verifier;
    final String[] cipherSuites;
    final String[] protocols;

    SslConfig(RepositorySystemSession session, AuthenticationContext authContext) {
        this.context = authContext != null ? authContext.get("ssl.context", SSLContext.class) : null;
        this.verifier = authContext != null ? authContext.get("ssl.hostnameVerifier", HostnameVerifier.class) : null;
        this.cipherSuites = SslConfig.split(SslConfig.get(session, CIPHER_SUITES));
        this.protocols = SslConfig.split(SslConfig.get(session, PROTOCOLS));
    }

    private static String get(RepositorySystemSession session, String key) {
        String value = ConfigUtils.getString(session, null, "aether.connector." + key, key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    private static String[] split(String value) {
        if (value == null || value.length() <= 0) {
            return null;
        }
        return value.split(",+");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SslConfig that = (SslConfig)obj;
        return Objects.equals(this.context, that.context) && Objects.equals(this.verifier, that.verifier) && Arrays.equals(this.cipherSuites, that.cipherSuites) && Arrays.equals(this.protocols, that.protocols);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + SslConfig.hash(this.context);
        hash = hash * 31 + SslConfig.hash(this.verifier);
        hash = hash * 31 + Arrays.hashCode(this.cipherSuites);
        hash = hash * 31 + Arrays.hashCode(this.protocols);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

