/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public abstract class AbstractEnvironmentDecrypt {
    private static final Pattern COLLECTION_PROPERTY = Pattern.compile("(\\S+)?\\[(\\d+)\\](\\.\\S+)?");
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    public static final String ENCRYPTED_PROPERTY_PREFIX = "{cipher}";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean failOnError = true;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    protected Map<String, Object> decrypt(TextEncryptor encryptor, PropertySources propertySources) {
        LinkedHashMap<String, Object> decryptedProperties = new LinkedHashMap<String, Object>();
        PropertyVisitor visitor = new PropertyVisitor();
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerable.getPropertyNames()) {
                if (visitor.isVisited(propertyName)) continue;
                Matcher collectionMatcher = COLLECTION_PROPERTY.matcher(propertyName);
                if (collectionMatcher.matches()) {
                    String name = collectionMatcher.group(1);
                    if (name == null) {
                        name = "";
                    }
                    IndexedValue indexed = this.getPropertyValues(enumerable, encryptor, name);
                    if (indexed.containsDecrypted) {
                        decryptedProperties.putAll(indexed.values);
                    }
                    visitor.visited(indexed.values.keySet());
                    continue;
                }
                SingleValue single = this.getPropertyValue((PropertySource<?>)enumerable, encryptor, propertyName);
                if (single.isDecrypted) {
                    decryptedProperties.put(propertyName, single.value);
                }
                visitor.visited(propertyName);
            }
        }
        return decryptedProperties;
    }

    protected String decrypt(TextEncryptor encryptor, String key, String original) {
        String value = original.substring(ENCRYPTED_PROPERTY_PREFIX.length());
        try {
            value = encryptor.decrypt(value);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Decrypted: key=" + key));
            }
            return value;
        }
        catch (Exception e) {
            String message = "Cannot decrypt: key=" + key;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)message, (Throwable)e);
            } else {
                this.logger.warn((Object)message);
            }
            if (this.failOnError) {
                throw new IllegalStateException(message, e);
            }
            return "";
        }
    }

    private IndexedValue getPropertyValues(EnumerablePropertySource<?> source, TextEncryptor encryptor, String matchingName) {
        String prefix = matchingName + "[";
        boolean containsDecrypted = false;
        HashMap<String, Object> elements = new HashMap<String, Object>();
        for (String name : source.getPropertyNames()) {
            if (!COLLECTION_PROPERTY.matcher(name).matches() || !name.startsWith(prefix)) continue;
            SingleValue value = this.getPropertyValue((PropertySource<?>)source, encryptor, name);
            elements.put(name, value.value);
            if (!value.isDecrypted) continue;
            containsDecrypted = true;
        }
        return new IndexedValue(elements, containsDecrypted);
    }

    private SingleValue getPropertyValue(PropertySource<?> source, TextEncryptor encryptor, String name) {
        String valueString;
        Object value = source.getProperty(name);
        if (value != null && (valueString = value.toString()).startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
            return new SingleValue(this.decrypt(encryptor, name, valueString), true);
        }
        return new SingleValue(value, false);
    }

    private static final class PropertyVisitor {
        private final SystemEnvironmentPropertySource propertySource = new SystemEnvironmentPropertySource("visitor", new HashMap());

        private PropertyVisitor() {
        }

        boolean isVisited(String name) {
            return this.propertySource.containsProperty(name);
        }

        void visited(String name) {
            ((Map)this.propertySource.getSource()).put(name, "");
        }

        void visited(Set<String> names) {
            for (String name : names) {
                ((Map)this.propertySource.getSource()).put(name, "");
            }
        }
    }

    private record IndexedValue(Map<String, Object> values, boolean containsDecrypted) {
    }

    private record SingleValue(Object value, boolean isDecrypted) {
    }
}

