/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.context.refresh.ConfigDataContextRefresher;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.refresh.LegacyContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.endpoint.event.RefreshEventListener;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.cloud.util.ConditionalOnBootstrapDisabled;
import org.springframework.cloud.util.ConditionalOnBootstrapEnabled;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.style.ToStringCreator;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RefreshScope.class})
@ConditionalOnProperty(name={"spring.cloud.refresh.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={HibernateJpaAutoConfiguration.class})
@EnableConfigurationProperties(value={RefreshProperties.class})
public class RefreshAutoConfiguration {
    public static final String REFRESH_SCOPE_NAME = "refresh";
    public static final String REFRESH_SCOPE_PREFIX = "spring.cloud.refresh";
    public static final String REFRESH_SCOPE_ENABLED = "spring.cloud.refresh.enabled";

    @Bean
    @ConditionalOnMissingBean(value={RefreshScope.class})
    public static RefreshScope refreshScope() {
        return new RefreshScope();
    }

    @Bean
    @ConditionalOnMissingBean
    public static LoggingRebinder loggingRebinder() {
        return new LoggingRebinder();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBootstrapEnabled
    public LegacyContextRefresher legacyContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshProperties properties) {
        return new LegacyContextRefresher(context, scope, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBootstrapDisabled
    public ConfigDataContextRefresher configDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshProperties properties) {
        return new ConfigDataContextRefresher(context, scope, properties);
    }

    @Bean
    public RefreshEventListener refreshEventListener(ContextRefresher contextRefresher) {
        return new RefreshEventListener(contextRefresher);
    }

    @ConfigurationProperties(value="spring.cloud.refresh")
    public static class RefreshProperties {
        private List<String> additionalPropertySourcesToRetain;

        public List<String> getAdditionalPropertySourcesToRetain() {
            return this.additionalPropertySourcesToRetain;
        }

        public void setAdditionalPropertySourcesToRetain(List<String> additionalPropertySourcesToRetain) {
            this.additionalPropertySourcesToRetain = additionalPropertySourcesToRetain;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("additionalPropertySourcesToRetain", this.additionalPropertySourcesToRetain).toString();
        }
    }

    @Component
    protected static class RefreshScopeBeanDefinitionEnhancer
    implements BeanDefinitionRegistryPostProcessor,
    EnvironmentAware {
        private Environment environment;
        private boolean bound = false;
        private Set<String> refreshables = new HashSet<String>();

        protected RefreshScopeBeanDefinitionEnhancer() {
        }

        public Set<String> getRefreshable() {
            return this.refreshables;
        }

        public void setRefreshable(Set<String> refreshables) {
            if (this.refreshables != refreshables) {
                this.refreshables.clear();
                this.refreshables.addAll(refreshables);
            }
        }

        public void setExtraRefreshable(Set<String> refreshables) {
            this.refreshables.addAll(refreshables);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            this.bindEnvironmentIfNeeded(registry);
            for (String name : registry.getBeanDefinitionNames()) {
                BeanDefinition definition = registry.getBeanDefinition(name);
                if (!this.isApplicable(registry, name, definition)) continue;
                BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, name);
                BeanDefinitionHolder proxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
                definition.setScope(RefreshAutoConfiguration.REFRESH_SCOPE_NAME);
                if (registry.containsBeanDefinition(proxy.getBeanName())) {
                    registry.removeBeanDefinition(proxy.getBeanName());
                }
                registry.registerBeanDefinition(proxy.getBeanName(), proxy.getBeanDefinition());
            }
        }

        private boolean isApplicable(BeanDefinitionRegistry registry, String name, BeanDefinition definition) {
            Class cls;
            String scope = definition.getScope();
            if (RefreshAutoConfiguration.REFRESH_SCOPE_NAME.equals(scope)) {
                return false;
            }
            String type = definition.getBeanClassName();
            if (!StringUtils.hasText((String)type) && registry instanceof BeanFactory && (cls = ((BeanFactory)registry).getType(name)) != null) {
                type = cls.getName();
            }
            if (type != null) {
                return this.refreshables.contains(type);
            }
            return false;
        }

        private void bindEnvironmentIfNeeded(BeanDefinitionRegistry registry) {
            if (!this.bound) {
                if (this.environment == null) {
                    this.environment = new StandardEnvironment();
                }
                Binder.get((Environment)this.environment).bind(RefreshAutoConfiguration.REFRESH_SCOPE_PREFIX, Bindable.ofInstance((Object)this));
                this.bound = true;
            }
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.persistence.EntityManagerFactory"})
    protected static class JpaInvokerConfiguration
    implements LoadTimeWeaverAware,
    InitializingBean {
        @Autowired
        private ListableBeanFactory beanFactory;

        protected JpaInvokerConfiguration() {
        }

        public void afterPropertiesSet() {
            String cls = "org.springframework.boot.autoconfigure.jdbc.DataSourceInitializerInvoker";
            if (this.beanFactory.containsBean(cls)) {
                this.beanFactory.getBean(cls);
            }
        }

        public void setLoadTimeWeaver(LoadTimeWeaver ltw) {
        }
    }
}

