/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.validation.constraints.NotEmpty;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.support.HttpEnvironmentRepositoryProperties;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.config.server.vault")
public class VaultEnvironmentProperties
implements HttpEnvironmentRepositoryProperties {
    private String host = "127.0.0.1";
    private Integer port = 8200;
    private String scheme = "http";
    private int timeout = 5;
    private String backend = "secret";
    private boolean fullKeyPath = false;
    private String defaultKey = "application";
    private String pathToKey = "";
    private String profileSeparator = ",";
    private boolean skipSslValidation = false;
    private Map<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> proxy = new HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties>();
    private int order = Integer.MAX_VALUE;
    private int kvVersion = 1;
    private String namespace;
    private String token;
    private boolean enableLabel = false;
    private String defaultLabel = "main";
    private AppRoleProperties appRole = new AppRoleProperties();
    private AwsEc2Properties awsEc2 = new AwsEc2Properties();
    private AwsIamProperties awsIam = new AwsIamProperties();
    private AzureMsiProperties azureMsi = new AzureMsiProperties();
    private GcpGceProperties gcpGce = new GcpGceProperties();
    private GcpIamProperties gcpIam = new GcpIamProperties();
    private KubernetesProperties kubernetes = new KubernetesProperties();
    private PcfProperties pcf = new PcfProperties();
    private Ssl ssl = new Ssl();
    private AuthenticationMethod authentication;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public boolean isFullKeyPath() {
        return this.fullKeyPath;
    }

    public void setFullKeyPath(boolean fullKeyPath) {
        this.fullKeyPath = fullKeyPath;
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    @Override
    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    @Override
    public Map<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> getProxy() {
        return this.proxy;
    }

    public void setProxy(Map<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> proxy) {
        this.proxy = proxy;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getKvVersion() {
        return this.kvVersion;
    }

    public void setKvVersion(int kvVersion) {
        this.kvVersion = kvVersion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isEnableLabel() {
        return this.enableLabel;
    }

    public void setEnableLabel(boolean enableLabel) {
        this.enableLabel = enableLabel;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public AppRoleProperties getAppRole() {
        return this.appRole;
    }

    public AwsEc2Properties getAwsEc2() {
        return this.awsEc2;
    }

    public AwsIamProperties getAwsIam() {
        return this.awsIam;
    }

    public AzureMsiProperties getAzureMsi() {
        return this.azureMsi;
    }

    public GcpGceProperties getGcpGce() {
        return this.gcpGce;
    }

    public GcpIamProperties getGcpIam() {
        return this.gcpIam;
    }

    public KubernetesProperties getKubernetes() {
        return this.kubernetes;
    }

    public PcfProperties getPcf() {
        return this.pcf;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setAuthentication(AuthenticationMethod authentication) {
        this.authentication = authentication;
    }

    public AuthenticationMethod getAuthentication() {
        return this.authentication;
    }

    public String getPathToKey() {
        return this.pathToKey;
    }

    public void setPathToKey(String pathToKey) {
        this.pathToKey = pathToKey;
    }

    @Validated
    public static class AppRoleProperties {
        private String appRolePath = "approle";
        private String role = "";
        private String roleId = null;
        private String secretId = null;

        public String getAppRolePath() {
            return this.appRolePath;
        }

        public String getRole() {
            return this.role;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public void setAppRolePath(String appRolePath) {
            this.appRolePath = appRolePath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }
    }

    @Validated
    public static class AwsEc2Properties {
        @NotEmpty
        private String identityDocument = "http://169.254.169.254/latest/dynamic/instance-identity/pkcs7";
        @NotEmpty
        private String awsEc2Path = "aws-ec2";
        private String role = "";
        private String nonce;

        public String getIdentityDocument() {
            return this.identityDocument;
        }

        public String getAwsEc2Path() {
            return this.awsEc2Path;
        }

        public String getRole() {
            return this.role;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setIdentityDocument(String identityDocument) {
            this.identityDocument = identityDocument;
        }

        public void setAwsEc2Path(String awsEc2Path) {
            this.awsEc2Path = awsEc2Path;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }
    }

    public static class AwsIamProperties {
        @NotEmpty
        private String awsPath = "aws";
        private String role = "";
        private String serverName;
        private URI endpointUri;

        public String getAwsPath() {
            return this.awsPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setAwsPath(String awsPath) {
            this.awsPath = awsPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public URI getEndpointUri() {
            return this.endpointUri;
        }

        public void setEndpointUri(URI endpointUri) {
            this.endpointUri = endpointUri;
        }
    }

    public static class AzureMsiProperties {
        @NotEmpty
        private String azurePath = "azure";
        private String role = "";
        private String identityTokenService = "";
        private String metadataService = "";

        public String getAzurePath() {
            return this.azurePath;
        }

        public String getIdentityTokenService() {
            return this.identityTokenService;
        }

        public String getMetadataService() {
            return this.metadataService;
        }

        public String getRole() {
            return this.role;
        }

        public void setAzurePath(String azurePath) {
            this.azurePath = azurePath;
        }

        public void setIdentityTokenService(String identityTokenService) {
            this.identityTokenService = identityTokenService;
        }

        public void setMetadataService(String metadataService) {
            this.metadataService = metadataService;
        }

        public void setRole(String role) {
            this.role = role;
        }
    }

    public static class GcpGceProperties {
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String serviceAccount = "";

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }
    }

    public static class GcpIamProperties {
        private final GcpCredentials credentials = new GcpCredentials();
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String projectId = "";
        private String serviceAccountId = "";
        private Duration jwtValidity = Duration.ofMinutes(15L);

        public GcpCredentials getCredentials() {
            return this.credentials;
        }

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public Duration getJwtValidity() {
            return this.jwtValidity;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        public void setJwtValidity(Duration jwtValidity) {
            this.jwtValidity = jwtValidity;
        }
    }

    public static class KubernetesProperties {
        @NotEmpty
        private String kubernetesPath = "kubernetes";
        private String role = "";
        @NotEmpty
        private String serviceAccountTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";

        public String getKubernetesPath() {
            return this.kubernetesPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccountTokenFile() {
            return this.serviceAccountTokenFile;
        }

        public void setKubernetesPath(String kubernetesPath) {
            this.kubernetesPath = kubernetesPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccountTokenFile(String serviceAccountTokenFile) {
            this.serviceAccountTokenFile = serviceAccountTokenFile;
        }
    }

    public static class PcfProperties {
        @NotEmpty
        private String pcfPath = "pcf";
        private String role = "";
        private Resource instanceCertificate;
        private Resource instanceKey;

        public String getPcfPath() {
            return this.pcfPath;
        }

        public void setPcfPath(String pcfPath) {
            this.pcfPath = pcfPath;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Resource getInstanceCertificate() {
            return this.instanceCertificate;
        }

        public void setInstanceCertificate(Resource instanceCertificate) {
            this.instanceCertificate = instanceCertificate;
        }

        public Resource getInstanceKey() {
            return this.instanceKey;
        }

        public void setInstanceKey(Resource instanceKey) {
            this.instanceKey = instanceKey;
        }
    }

    @Validated
    public static class Ssl {
        private Resource keyStore;
        private String keyStorePassword;
        private Resource trustStore;
        private String trustStorePassword;
        @NotEmpty
        private String certAuthPath = "cert";

        public Resource getKeyStore() {
            return this.keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public Resource getTrustStore() {
            return this.trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String getCertAuthPath() {
            return this.certAuthPath;
        }

        public void setKeyStore(Resource keyStore) {
            this.keyStore = keyStore;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public void setTrustStore(Resource trustStore) {
            this.trustStore = trustStore;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public void setCertAuthPath(String certAuthPath) {
            this.certAuthPath = certAuthPath;
        }
    }

    public static enum AuthenticationMethod {
        APPROLE,
        AWS_EC2,
        AWS_IAM,
        AZURE_MSI,
        CERT,
        CUBBYHOLE,
        GCP_GCE,
        GCP_IAM,
        KUBERNETES,
        PCF,
        TOKEN;

    }

    public static class GcpCredentials {
        private Resource location;
        private String encodedKey;

        public Resource getLocation() {
            return this.location;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }
    }
}

