/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption.vault;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.encryption.CipherEnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.util.ObjectUtils;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.support.VaultResponse;

public class VaultEnvironmentEncryptor
implements EnvironmentEncryptor {
    private static final Log logger = LogFactory.getLog(CipherEnvironmentEncryptor.class);
    private final VaultKeyValueOperations keyValueTemplate;
    private boolean prefixInvalidProperties = true;

    public VaultEnvironmentEncryptor(VaultKeyValueOperations keyValueTemplate) {
        this.keyValueTemplate = keyValueTemplate;
    }

    @Override
    public Environment decrypt(Environment environment) {
        HashMap<String, VaultResponse> loadedVaultKeys = new HashMap<String, VaultResponse>();
        Environment result = new Environment(environment);
        for (PropertySource source : environment.getPropertySources()) {
            LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>(source.getSource());
            for (Map.Entry entry : new LinkedHashSet(map.entrySet())) {
                String value;
                Object name;
                block11: {
                    Object key = entry.getKey();
                    name = key.toString();
                    if (entry.getValue() == null || !entry.getValue().toString().startsWith("{vault}")) continue;
                    value = entry.getValue().toString();
                    map.remove(key);
                    try {
                        VaultResponse vaultResponse;
                        value = value.substring("{vault}".length());
                        if (!value.startsWith(":")) {
                            throw new RuntimeException("Wrong format");
                        }
                        if (!(value = value.substring(1)).contains("#")) {
                            throw new RuntimeException("Wrong format");
                        }
                        String[] parts = value.split("#");
                        if (parts.length == 1) {
                            throw new RuntimeException("Wrong format");
                        }
                        if (ObjectUtils.isEmpty((Object)parts[0]) || ObjectUtils.isEmpty((Object)parts[1])) {
                            throw new RuntimeException("Wrong format");
                        }
                        String vaultKey = parts[0];
                        String vaultParamName = parts[1];
                        if (!loadedVaultKeys.containsKey(vaultKey)) {
                            loadedVaultKeys.put(vaultKey, this.keyValueTemplate.get(vaultKey));
                        }
                        value = (vaultResponse = (VaultResponse)loadedVaultKeys.get(vaultKey)) == null || vaultResponse.getData() == null || !((Map)vaultResponse.getData()).containsKey(vaultParamName) ? null : ((Map)vaultResponse.getData()).get(vaultParamName).toString();
                    }
                    catch (Exception e) {
                        if (this.prefixInvalidProperties) {
                            value = "<n/a>";
                            name = "invalid." + (String)name;
                        }
                        String message = "Cannot resolve key: " + String.valueOf(key) + " (" + String.valueOf(e.getClass()) + ": " + e.getMessage() + ")";
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)message, (Throwable)e);
                        }
                        if (!logger.isWarnEnabled()) break block11;
                        logger.warn((Object)message);
                    }
                }
                map.put(name, value);
            }
            result.add(new PropertySource(source.getName(), map));
        }
        return result;
    }

    public void setPrefixInvalidProperties(boolean prefixInvalidProperties) {
        this.prefixInvalidProperties = prefixInvalidProperties;
    }
}

