/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;

public class AppRoleClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public AppRoleClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.APPROLE);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions(vaultProperties);
        return new AppRoleAuthentication(options, vaultRestOperations);
    }

    static AppRoleAuthenticationOptions getAppRoleAuthenticationOptions(VaultEnvironmentProperties vaultProperties) {
        VaultEnvironmentProperties.AppRoleProperties appRole = vaultProperties.getAppRole();
        AppRoleAuthenticationOptions.AppRoleAuthenticationOptionsBuilder builder = AppRoleAuthenticationOptions.builder().path(appRole.getAppRolePath());
        if (StringUtils.hasText((String)appRole.getRole())) {
            builder.appRole(appRole.getRole());
        }
        AppRoleAuthenticationOptions.RoleId roleId = AppRoleClientAuthenticationProvider.getRoleId(vaultProperties, appRole);
        AppRoleAuthenticationOptions.SecretId secretId = AppRoleClientAuthenticationProvider.getSecretId(vaultProperties, appRole);
        builder.roleId(roleId).secretId(secretId);
        return builder.build();
    }

    private static AppRoleAuthenticationOptions.RoleId getRoleId(VaultEnvironmentProperties vaultProperties, VaultEnvironmentProperties.AppRoleProperties appRole) {
        if (StringUtils.hasText((String)appRole.getRoleId())) {
            return AppRoleAuthenticationOptions.RoleId.provided((String)appRole.getRoleId());
        }
        if (StringUtils.hasText((String)vaultProperties.getToken()) && StringUtils.hasText((String)appRole.getRole())) {
            return AppRoleAuthenticationOptions.RoleId.pull((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        if (StringUtils.hasText((String)vaultProperties.getToken())) {
            return AppRoleAuthenticationOptions.RoleId.wrapped((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        throw new IllegalArgumentException("Any of 'spring.cloud.config.server.vault.app-role.role-id', '.token', or '.app-role.role' and '.token' must be provided if the " + String.valueOf((Object)VaultEnvironmentProperties.AuthenticationMethod.APPROLE) + " authentication method is specified.");
    }

    private static AppRoleAuthenticationOptions.SecretId getSecretId(VaultEnvironmentProperties vaultProperties, VaultEnvironmentProperties.AppRoleProperties appRole) {
        if (StringUtils.hasText((String)appRole.getSecretId())) {
            return AppRoleAuthenticationOptions.SecretId.provided((String)appRole.getSecretId());
        }
        if (StringUtils.hasText((String)vaultProperties.getToken()) && StringUtils.hasText((String)appRole.getRole())) {
            return AppRoleAuthenticationOptions.SecretId.pull((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        if (StringUtils.hasText((String)vaultProperties.getToken())) {
            return AppRoleAuthenticationOptions.SecretId.wrapped((VaultToken)VaultToken.of((String)vaultProperties.getToken()));
        }
        return AppRoleAuthenticationOptions.SecretId.absent();
    }
}

