/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.cloud.client.loadbalancer.DeferringLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.util.UriComponentsBuilder;

public class LoadBalancerRestClientHttpServiceGroupConfigurer
implements RestClientHttpServiceGroupConfigurer {
    private static final int ORDER = 10;
    private final SingletonSupplier<DeferringLoadBalancerInterceptor> loadBalancerInterceptorSupplier = SingletonSupplier.ofNullable(() -> loadBalancerInterceptorProvider.getIfAvailable());
    private final HttpServiceClientProperties clientServiceProperties;

    public LoadBalancerRestClientHttpServiceGroupConfigurer(ObjectProvider<DeferringLoadBalancerInterceptor> loadBalancerInterceptorProvider, HttpServiceClientProperties clientServiceProperties) {
        this.clientServiceProperties = clientServiceProperties;
    }

    public void configureGroups(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HttpServiceGroupConfigurer.Groups<// Could not load outer class - annotation placement on inner may be incorrect
    RestClient.Builder> groups) {
        DeferringLoadBalancerInterceptor loadBalancerInterceptor = (DeferringLoadBalancerInterceptor)this.loadBalancerInterceptorSupplier.get();
        if (loadBalancerInterceptor == null) {
            throw new IllegalStateException(DeferringLoadBalancerInterceptor.class.getSimpleName() + " bean not available.");
        }
        groups.forEachGroup((group, clientBuilder, factoryBuilder) -> {
            URI existingBaseUrl;
            String groupName = group.name();
            HttpClientProperties groupProperties = this.clientServiceProperties.get(groupName);
            String baseUrlString = groupProperties == null ? null : groupProperties.getBaseUrl();
            URI uRI = existingBaseUrl = baseUrlString == null ? null : URI.create(baseUrlString);
            if (existingBaseUrl == null) {
                URI baseUrl = this.constructBaseUrl(groupName);
                clientBuilder.baseUrl(baseUrl);
                clientBuilder.requestInterceptor((ClientHttpRequestInterceptor)loadBalancerInterceptor);
            } else if ("lb".equalsIgnoreCase(existingBaseUrl.getScheme())) {
                URI baseUrl = UriComponentsBuilder.fromUri((URI)existingBaseUrl).scheme("http").build().toUri();
                clientBuilder.baseUrl(baseUrl);
                clientBuilder.requestInterceptor((ClientHttpRequestInterceptor)loadBalancerInterceptor);
            }
        });
    }

    public int getOrder() {
        return 10;
    }

    private URI constructBaseUrl(String groupName) {
        return LoadBalancerUriTools.constructInterfaceClientsBaseUrl(groupName);
    }
}

