/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.core.style.ToStringCreator;

public class CompletionContext<RES, T, C> {
    private final Status status;
    private final @Nullable Throwable throwable;
    private final @Nullable Response<T> loadBalancerResponse;
    private final @Nullable RES clientResponse;
    private final Request<C> loadBalancerRequest;

    public CompletionContext(Status status, Request<C> loadBalancerRequest) {
        this(status, null, loadBalancerRequest, null, null);
    }

    public CompletionContext(Status status, Request<C> loadBalancerRequest, @Nullable Response<T> response) {
        this(status, null, loadBalancerRequest, response, null);
    }

    public CompletionContext(Status status, Throwable throwable, Request<C> loadBalancerRequest, @Nullable Response<T> loadBalancerResponse) {
        this(status, throwable, loadBalancerRequest, loadBalancerResponse, null);
    }

    public CompletionContext(Status status, Request<C> loadBalancerRequest, @Nullable Response<T> loadBalancerResponse, @Nullable RES clientResponse) {
        this(status, null, loadBalancerRequest, loadBalancerResponse, clientResponse);
    }

    public CompletionContext(Status status, @Nullable Throwable throwable, Request<C> loadBalancerRequest, @Nullable Response<T> loadBalancerResponse, @Nullable RES clientResponse) {
        this.status = status;
        this.throwable = throwable;
        this.loadBalancerRequest = loadBalancerRequest;
        this.loadBalancerResponse = loadBalancerResponse;
        this.clientResponse = clientResponse;
    }

    public Status status() {
        return this.status;
    }

    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    public @Nullable Response<T> getLoadBalancerResponse() {
        return this.loadBalancerResponse;
    }

    public @Nullable RES getClientResponse() {
        return this.clientResponse;
    }

    public Request<C> getLoadBalancerRequest() {
        return this.loadBalancerRequest;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("status", (Object)this.status);
        to.append("throwable", (Object)this.throwable);
        to.append("loadBalancerResponse", this.loadBalancerResponse);
        to.append("clientResponse", this.clientResponse);
        return to.toString();
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        DISCARD;

    }
}

