/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.InstanceProperties;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryProperties;
import reactor.core.publisher.Flux;

public class SimpleReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private SimpleReactiveDiscoveryProperties simpleDiscoveryProperties;

    public SimpleReactiveDiscoveryClient(SimpleReactiveDiscoveryProperties simpleDiscoveryProperties) {
        this.simpleDiscoveryProperties = simpleDiscoveryProperties;
    }

    @Override
    public String description() {
        return "Simple Reactive Discovery Client";
    }

    @Override
    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.fromIterable(this.simpleDiscoveryProperties.getInstances(serviceId).stream().map(InstanceProperties::toServiceInstance).toList());
    }

    @Override
    public Flux<String> getServices() {
        return Flux.fromIterable(this.simpleDiscoveryProperties.getInstances().keySet());
    }

    @Override
    public int getOrder() {
        return this.simpleDiscoveryProperties.getOrder();
    }
}

