/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerConfigurerUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapterDecorator;
import org.springframework.web.service.invoker.HttpRequestValues;

public class CircuitBreakerAdapterDecorator
extends HttpExchangeAdapterDecorator {
    private static final Log LOG = LogFactory.getLog(CircuitBreakerAdapterDecorator.class);
    private final CircuitBreaker circuitBreaker;
    private final Map<String, Class<?>> fallbackClasses;
    private volatile Map<String, Object> fallbackProxies;

    public CircuitBreakerAdapterDecorator(HttpExchangeAdapter delegate, CircuitBreaker circuitBreaker, Map<String, Class<?>> fallbackClasses) {
        super(delegate);
        this.circuitBreaker = circuitBreaker;
        this.fallbackClasses = fallbackClasses;
    }

    public void exchange(HttpRequestValues requestValues) {
        this.circuitBreaker.run(() -> {
            super.exchange(requestValues);
            return null;
        }, this.createFallbackHandler(requestValues));
    }

    public HttpHeaders exchangeForHeaders(HttpRequestValues values) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForHeaders(values), this.createFallbackHandler(values));
        return (HttpHeaders)this.castIfPossible(result);
    }

    public <T> @Nullable T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForBody(values, bodyType), this.createFallbackHandler(values));
        return this.castIfPossible(result);
    }

    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForBodilessEntity(values), this.createFallbackHandler(values));
        return (ResponseEntity)this.castIfPossible(result);
    }

    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForEntity(values, bodyType), this.createFallbackHandler(values));
        return (ResponseEntity)this.castIfPossible(result);
    }

    CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    Map<String, Class<?>> getFallbackClasses() {
        return this.fallbackClasses;
    }

    private <T> T castIfPossible(Object result) {
        try {
            return (T)result;
        }
        catch (ClassCastException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Failed to cast object of type " + String.valueOf(result.getClass()) + " to expected type."));
            }
            throw exception;
        }
    }

    Function<Throwable, Object> createFallbackHandler(HttpRequestValues requestValues) {
        return throwable -> CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getFallbackProxies() {
        if (this.fallbackProxies == null) {
            CircuitBreakerAdapterDecorator circuitBreakerAdapterDecorator = this;
            synchronized (circuitBreakerAdapterDecorator) {
                if (this.fallbackProxies == null) {
                    this.fallbackProxies = CircuitBreakerConfigurerUtils.createProxies(this.fallbackClasses);
                }
            }
        }
        return this.fallbackProxies;
    }
}

