/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.ConfigurationPropertiesUtils;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreaker;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigurationProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.observation.ObservedCircuitBreaker;
import org.springframework.util.Assert;

public class Resilience4JCircuitBreakerFactory
extends CircuitBreakerFactory<Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration, Resilience4JConfigBuilder> {
    private Resilience4jBulkheadProvider bulkheadProvider;
    private Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration;
    private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    private TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Function<String, ExecutorService> groupExecutorServiceFactory = group -> Executors.newCachedThreadPool();
    private ConcurrentHashMap<String, ExecutorService> executorServices = new ConcurrentHashMap();
    private Map<String, Customizer<CircuitBreaker>> circuitBreakerCustomizers = new HashMap<String, Customizer<CircuitBreaker>>();
    private Resilience4JConfigurationProperties resilience4JConfigurationProperties;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

    public Resilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Resilience4jBulkheadProvider bulkheadProvider) {
        this(circuitBreakerRegistry, timeLimiterRegistry, bulkheadProvider, new Resilience4JConfigurationProperties());
    }

    public Resilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Resilience4jBulkheadProvider bulkheadProvider, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.bulkheadProvider = bulkheadProvider;
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig((CircuitBreakerConfig)this.circuitBreakerRegistry.getDefaultConfig()).timeLimiterConfig((TimeLimiterConfig)this.timeLimiterRegistry.getDefaultConfig()).build();
        this.resilience4JConfigurationProperties = resilience4JConfigurationProperties;
    }

    protected Resilience4JConfigBuilder configBuilder(String id) {
        return new Resilience4JConfigBuilder(id);
    }

    public void configureDefault(Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configureCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        this.circuitBreakerRegistry = registry;
    }

    public CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return this.circuitBreakerRegistry;
    }

    public TimeLimiterRegistry getTimeLimiterRegistry() {
        return this.timeLimiterRegistry;
    }

    public Resilience4jBulkheadProvider getBulkheadProvider() {
        return this.bulkheadProvider;
    }

    public void configureExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void configureGroupExecutorService(Function<String, ExecutorService> groupFactory) {
        this.groupExecutorServiceFactory = groupFactory;
    }

    public org.springframework.cloud.client.circuitbreaker.CircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Resilience4JCircuitBreaker resilience4JCircuitBreaker = this.create(id, id, this.executorService);
        return this.tryObservedCircuitBreaker(resilience4JCircuitBreaker);
    }

    public org.springframework.cloud.client.circuitbreaker.CircuitBreaker create(String id, String groupName) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Assert.hasText((String)groupName, (String)"A CircuitBreaker must have a group name.");
        ExecutorService groupExecutorService = this.executorServices.computeIfAbsent(groupName, this.groupExecutorServiceFactory);
        Resilience4JCircuitBreaker resilience4JCircuitBreaker = this.create(id, groupName, groupExecutorService);
        return this.tryObservedCircuitBreaker(resilience4JCircuitBreaker);
    }

    private org.springframework.cloud.client.circuitbreaker.CircuitBreaker tryObservedCircuitBreaker(Resilience4JCircuitBreaker resilience4JCircuitBreaker) {
        if (this.observationRegistry.isNoop()) {
            return resilience4JCircuitBreaker;
        }
        return new ObservedCircuitBreaker((org.springframework.cloud.client.circuitbreaker.CircuitBreaker)resilience4JCircuitBreaker, this.observationRegistry);
    }

    public void addCircuitBreakerCustomizer(Customizer<CircuitBreaker> customizer, String ... ids) {
        for (String id : ids) {
            this.circuitBreakerCustomizers.put(id, customizer);
        }
    }

    private Resilience4JCircuitBreaker create(String id, String groupName, ExecutorService circuitBreakerExecutorService) {
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration defaultConfig = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        CircuitBreakerConfig circuitBreakerConfig = this.circuitBreakerRegistry.getConfiguration(id).orElseGet(() -> this.circuitBreakerRegistry.getConfiguration(groupName).orElseGet(defaultConfig::getCircuitBreakerConfig));
        TimeLimiterConfig timeLimiterConfig = this.timeLimiterRegistry.getConfiguration(id).orElseGet(() -> this.timeLimiterRegistry.getConfiguration(groupName).orElseGet(defaultConfig::getTimeLimiterConfig));
        if (this.resilience4JConfigurationProperties.isDisableThreadPool()) {
            return new Resilience4JCircuitBreaker(id, groupName, circuitBreakerConfig, timeLimiterConfig, this.circuitBreakerRegistry, this.timeLimiterRegistry, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)), this.bulkheadProvider);
        }
        boolean isDisableTimeLimiter = ConfigurationPropertiesUtils.isDisableTimeLimiter(this.resilience4JConfigurationProperties, id, groupName);
        return new Resilience4JCircuitBreaker(id, groupName, circuitBreakerConfig, timeLimiterConfig, this.circuitBreakerRegistry, this.timeLimiterRegistry, circuitBreakerExecutorService, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)), this.bulkheadProvider, isDisableTimeLimiter);
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }
}

