/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms;

import jakarta.jms.ConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.jms.connection.CachingConnectionFactory;

public final class ConnectionFactoryUnwrapper {
    private ConnectionFactoryUnwrapper() {
    }

    public static ConnectionFactory unwrap(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof CachingConnectionFactory) {
            CachingConnectionFactory cachingConnectionFactory = (CachingConnectionFactory)connectionFactory;
            return ConnectionFactoryUnwrapper.unwrap(cachingConnectionFactory.getTargetConnectionFactory());
        }
        ConnectionFactory unwrapedConnectionFactory = ConnectionFactoryUnwrapper.unwrapFromJmsPoolConnectionFactory(connectionFactory);
        return unwrapedConnectionFactory != null ? ConnectionFactoryUnwrapper.unwrap(unwrapedConnectionFactory) : connectionFactory;
    }

    private static ConnectionFactory unwrapFromJmsPoolConnectionFactory(ConnectionFactory connectionFactory) {
        try {
            if (connectionFactory instanceof JmsPoolConnectionFactory) {
                JmsPoolConnectionFactory jmsPoolConnectionFactory = (JmsPoolConnectionFactory)connectionFactory;
                return (ConnectionFactory)jmsPoolConnectionFactory.getConnectionFactory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

