/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.io;

import java.util.List;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationResourceLoader
extends DefaultResourceLoader {
    @Deprecated(since="3.4.0", forRemoval=true)
    public ApplicationResourceLoader() {
        this(null);
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    public ApplicationResourceLoader(ClassLoader classLoader) {
        super(classLoader);
        SpringFactoriesLoader loader = SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader);
        this.getProtocolResolvers().addAll(loader.load(ProtocolResolver.class));
    }

    protected Resource getResourceByPath(String path) {
        return new ApplicationResource(path);
    }

    public static ResourceLoader get() {
        return ApplicationResourceLoader.get((ClassLoader)null);
    }

    public static ResourceLoader get(ClassLoader classLoader) {
        return ApplicationResourceLoader.get(classLoader, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader));
    }

    public static ResourceLoader get(ClassLoader classLoader, SpringFactoriesLoader springFactoriesLoader) {
        return ApplicationResourceLoader.get(ApplicationFileSystemResourceLoader.get(classLoader), springFactoriesLoader);
    }

    public static ResourceLoader get(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        return ApplicationResourceLoader.get(resourceLoader, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)resourceLoader.getClassLoader()));
    }

    public static ResourceLoader get(ResourceLoader resourceLoader, SpringFactoriesLoader springFactoriesLoader) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        Assert.notNull((Object)springFactoriesLoader, (String)"'springFactoriesLoader' must not be null");
        return new ProtocolResolvingResourceLoader(resourceLoader, springFactoriesLoader.load(ProtocolResolver.class));
    }

    private static final class ApplicationResource
    extends FileSystemResource
    implements ContextResource {
        ApplicationResource(String path) {
            super(path);
        }

        public String getPathWithinContext() {
            return this.getPath();
        }
    }

    private static final class ApplicationFileSystemResourceLoader
    extends DefaultResourceLoader {
        private static final ResourceLoader shared = new ApplicationFileSystemResourceLoader(null);

        private ApplicationFileSystemResourceLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        protected Resource getResourceByPath(String path) {
            return new ApplicationResource(path);
        }

        static ResourceLoader get(ClassLoader classLoader) {
            return classLoader != null ? new ApplicationFileSystemResourceLoader(classLoader) : shared;
        }
    }

    private static class ProtocolResolvingResourceLoader
    implements ResourceLoader {
        private final ResourceLoader resourceLoader;
        private final List<ProtocolResolver> protocolResolvers;

        ProtocolResolvingResourceLoader(ResourceLoader resourceLoader, List<ProtocolResolver> protocolResolvers) {
            this.resourceLoader = resourceLoader;
            this.protocolResolvers = protocolResolvers;
        }

        public Resource getResource(String location) {
            if (StringUtils.hasLength((String)location)) {
                for (ProtocolResolver protocolResolver : this.protocolResolvers) {
                    Resource resource = protocolResolver.resolve(location, (ResourceLoader)this);
                    if (resource == null) continue;
                    return resource;
                }
            }
            return this.resourceLoader.getResource(location);
        }

        public ClassLoader getClassLoader() {
            return this.resourceLoader.getClassLoader();
        }
    }
}

