/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webservices.client;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.ClientHttpRequestMessageSender;

@FunctionalInterface
public interface WebServiceMessageSenderFactory {
    public WebServiceMessageSender getWebServiceMessageSender();

    public static WebServiceMessageSenderFactory http() {
        return WebServiceMessageSenderFactory.http(ClientHttpRequestFactoryBuilder.detect(), null);
    }

    public static WebServiceMessageSenderFactory http(HttpClientSettings clientSettings) {
        return WebServiceMessageSenderFactory.http(ClientHttpRequestFactoryBuilder.detect(), clientSettings);
    }

    public static WebServiceMessageSenderFactory http(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder, @Nullable HttpClientSettings clientSettings) {
        Assert.notNull(requestFactoryBuilder, (String)"'requestFactoryBuilder' must not be null");
        return () -> new ClientHttpRequestMessageSender(requestFactoryBuilder.build(clientSettings));
    }
}

