/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.context;

import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.lang.Contract;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class SpringBootTestRandomPortContextCustomizer
implements ContextCustomizer {
    private static final String TEST_SOURCE_NAME = "Inlined Test Properties";

    SpringBootTestRandomPortContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        this.postProcessEnvironment(context.getEnvironment());
    }

    void postProcessEnvironment(ConfigurableEnvironment environment) {
        MapPropertySource testSource = (MapPropertySource)environment.getPropertySources().get(TEST_SOURCE_NAME);
        if (testSource != null) {
            MutablePropertySources nonTestSources = new MutablePropertySources((PropertySources)environment.getPropertySources());
            nonTestSources.remove(TEST_SOURCE_NAME);
            Ports ports = new Ports((PropertyResolver)environment, (ConversionService)environment.getConversionService());
            String value = this.getManagementServerPortPropertyValue(testSource, nonTestSources, ports);
            if (value != null) {
                ((Map)testSource.getSource()).put(Port.MANAGEMENT.property(), value);
            }
        }
    }

    private @Nullable String getManagementServerPortPropertyValue(MapPropertySource testSource, MutablePropertySources nonTestSources, Ports ports) {
        if (ports.isFixed(testSource, Port.SERVER) || ports.isConfigured((PropertySource<?>)testSource, Port.MANAGEMENT)) {
            return null;
        }
        Integer managementPort = ports.get((PropertySources)nonTestSources, Port.MANAGEMENT, null);
        if (managementPort == null || managementPort.equals(-1) || managementPort.equals(0)) {
            return null;
        }
        Integer serverPort = ports.get((PropertySources)nonTestSources, Port.SERVER, (Integer)8080);
        return !managementPort.equals(serverPort) ? "0" : "";
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private record Ports(PropertyResolver resolver, ConversionService conversionService) {
        private static final Integer ZERO = 0;

        boolean isFixed(MapPropertySource source, Port port) {
            return !ZERO.equals(this.get((PropertySource<?>)source, port, null));
        }

        boolean isConfigured(PropertySource<?> source, Port port) {
            return source.getProperty(port.property()) != null;
        }

        @Contract(value="_, _, !null -> !null")
        @Nullable Integer get(PropertySources sources, Port port, @Nullable Integer defaultValue) {
            return sources.stream().map(source -> this.get((PropertySource<?>)source, port, defaultValue)).filter(Objects::nonNull).findFirst().orElse(defaultValue);
        }

        @Contract(value="_, _, !null -> !null")
        @Nullable Integer get(PropertySource<?> source, Port port, @Nullable Integer defaultValue) {
            Object value = source.getProperty(port.property());
            if (value == null || ClassUtils.isAssignableValue(Integer.class, (Object)value)) {
                return (Integer)value;
            }
            try {
                return this.asInteger(value);
            }
            catch (ConversionFailedException ex) {
                if (value instanceof String) {
                    String string = (String)value;
                    return this.asInteger(this.resolver().resolveRequiredPlaceholders(string));
                }
                throw ex;
            }
        }

        private @Nullable Integer asInteger(@Nullable Object value) {
            return (Integer)this.conversionService().convert(value, Integer.class);
        }
    }

    private static enum Port {
        SERVER("server.port"),
        MANAGEMENT("management.server.port");

        private final String property;

        private Port(String property) {
            this.property = property;
        }

        String property() {
            return this.property;
        }
    }
}

