/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.ldap;

import org.springframework.boot.autoconfigure.ldap.LdapConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.ldap.LLdapContainer;

class LLdapContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LLdapContainer, LdapConnectionDetails> {
    LLdapContainerConnectionDetailsFactory() {
    }

    @Override
    protected LdapConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LLdapContainer> source) {
        return new LLdapContainerConnectionDetails(source);
    }

    private static final class LLdapContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LLdapContainer>
    implements LdapConnectionDetails {
        private LLdapContainerConnectionDetails(ContainerConnectionSource<LLdapContainer> source) {
            super(source);
        }

        public String[] getUrls() {
            return new String[]{((LLdapContainer)this.getContainer()).getLdapUrl()};
        }

        public String getBase() {
            return ((LLdapContainer)this.getContainer()).getBaseDn();
        }

        public String getUsername() {
            return ((LLdapContainer)this.getContainer()).getUser();
        }

        public String getPassword() {
            return ((LLdapContainer)this.getContainer()).getPassword();
        }
    }
}

