/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MockDefinition
extends Definition {
    private static final int MULTIPLIER = 31;
    private final ResolvableType typeToMock;
    private final Set<Class<?>> extraInterfaces;
    private final Answers answer;
    private final boolean serializable;

    MockDefinition(String name, ResolvableType typeToMock, Class<?>[] extraInterfaces, Answers answer, boolean serializable, MockReset reset, QualifierDefinition qualifier) {
        super(name, reset, false, qualifier);
        Assert.notNull((Object)typeToMock, (String)"TypeToMock must not be null");
        this.typeToMock = typeToMock;
        this.extraInterfaces = this.asClassSet(extraInterfaces);
        this.answer = answer != null ? answer : Answers.RETURNS_DEFAULTS;
        this.serializable = serializable;
    }

    private Set<Class<?>> asClassSet(Class<?>[] classes) {
        LinkedHashSet classSet = new LinkedHashSet();
        if (classes != null) {
            classSet.addAll(Arrays.asList(classes));
        }
        return Collections.unmodifiableSet(classSet);
    }

    public ResolvableType getTypeToMock() {
        return this.typeToMock;
    }

    public Set<Class<?>> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public Answers getAnswer() {
        return this.answer;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MockDefinition other = (MockDefinition)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals((Object)this.typeToMock, (Object)other.typeToMock);
        result = result && ObjectUtils.nullSafeEquals(this.extraInterfaces, other.extraInterfaces);
        result = result && ObjectUtils.nullSafeEquals((Object)this.answer, (Object)other.answer);
        result = result && this.serializable == other.serializable;
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.typeToMock);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.extraInterfaces);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.answer);
        result = 31 * result + Boolean.hashCode(this.serializable);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("typeToMock", (Object)this.typeToMock).append("extraInterfaces", this.extraInterfaces).append("answer", (Object)this.answer).append("serializable", this.serializable).append("reset", (Object)this.getReset()).toString();
    }

    public <T> T createMock() {
        return this.createMock(this.getName());
    }

    public <T> T createMock(String name) {
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (!this.extraInterfaces.isEmpty()) {
            settings.extraInterfaces(ClassUtils.toClassArray(this.extraInterfaces));
        }
        settings.defaultAnswer((Answer)this.answer);
        if (this.serializable) {
            settings.serializable();
        }
        return (T)Mockito.mock((Class)this.typeToMock.resolve(), (MockSettings)settings);
    }
}

