/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.autoconfigure.web.reactive.WebTestClientAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcTesterConfiguration;
import org.springframework.boot.test.web.reactive.server.WebTestClientBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.client.MockMvcWebTestClient;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(after={WebMvcAutoConfiguration.class, WebTestClientAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={ServerProperties.class, WebMvcProperties.class})
@Import(value={MockMvcConfiguration.class, MockMvcTesterConfiguration.class})
public class MockMvcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DispatcherServletPath dispatcherServletPath(WebMvcProperties webMvcProperties) {
        return () -> webMvcProperties.getServlet().getPath();
    }

    @Bean
    @ConditionalOnMissingBean
    public DispatcherServlet dispatcherServlet(MockMvc mockMvc) {
        return mockMvc.getDispatcherServlet();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class, WebTestClient.class})
    static class WebTestClientMockMvcConfiguration {
        WebTestClientMockMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        WebTestClient webTestClient(MockMvc mockMvc, List<WebTestClientBuilderCustomizer> customizers) {
            WebTestClient.Builder builder = MockMvcWebTestClient.bindTo((MockMvc)mockMvc);
            for (WebTestClientBuilderCustomizer customizer : customizers) {
                customizer.customize(builder);
            }
            return builder.build();
        }
    }
}

