/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.autoconfigure;

import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionCookieConfig;
import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWarDeployment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWarDeployment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.session.autoconfigure.DefaultCookieSerializerCustomizer;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.autoconfigure.SessionRepositoryFilterConfiguration;
import org.springframework.boot.session.autoconfigure.SessionTimeout;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.session.Session;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

@AutoConfiguration
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={SessionProperties.class})
public final class SessionAutoConfiguration {
    private static Duration determineTimeout(SessionProperties sessionProperties, Supplier<Duration> fallbackTimeout) {
        Duration timeout = sessionProperties.getTimeout();
        return timeout != null ? timeout : fallbackTimeout.get();
    }

    static class DefaultCookieSerializerCondition
    extends AnyNestedCondition {
        DefaultCookieSerializerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CookieHttpSessionIdResolver.class})
        @ConditionalOnMissingBean(value={CookieSerializer.class})
        static class CookieHttpSessionIdResolverAvailable {
            CookieHttpSessionIdResolverAvailable() {
            }
        }

        @ConditionalOnMissingBean(value={HttpSessionIdResolver.class, CookieSerializer.class})
        static class NoComponentsAvailable {
            NoComponentsAvailable() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveSessionConfiguration {
        ReactiveSessionConfiguration() {
        }

        @Bean
        SessionTimeout embeddedWebServerSessionTimeout(SessionProperties sessionProperties, ServerProperties serverProperties) {
            return () -> SessionAutoConfiguration.determineTimeout(sessionProperties, () -> ((ServerProperties.Reactive.Session)serverProperties.getReactive().getSession()).getTimeout());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Import(value={SessionRepositoryFilterConfiguration.class})
    static class ServletSessionConfiguration {
        ServletSessionConfiguration() {
        }

        @ConditionalOnWarDeployment
        static class WarDepoymentConfiguration
        implements ServletContextAware {
            private @Nullable ServletContext servletContext;

            WarDepoymentConfiguration() {
            }

            public void setServletContext(ServletContext servletContext) {
                this.servletContext = servletContext;
            }

            @Bean
            SessionTimeout warDeplomentSessionTimeout(SessionProperties sessionProperties) {
                return sessionProperties::getTimeout;
            }

            @Bean
            @Conditional(value={DefaultCookieSerializerCondition.class})
            DefaultCookieSerializer cookieSerializer(ObjectProvider<DefaultCookieSerializerCustomizer> cookieSerializerCustomizers) {
                DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
                PropertyMapper map = PropertyMapper.get();
                Assert.notNull((Object)this.servletContext, (String)"ServletContext is required for session configuration in a war deployment");
                SessionCookieConfig cookie = this.servletContext.getSessionCookieConfig();
                map.from(() -> ((SessionCookieConfig)cookie).getName()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieName(arg_0));
                map.from(() -> ((SessionCookieConfig)cookie).getDomain()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setDomainName(arg_0));
                map.from(() -> ((SessionCookieConfig)cookie).getPath()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookiePath(arg_0));
                map.from(() -> ((SessionCookieConfig)cookie).isHttpOnly()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseHttpOnlyCookie(arg_0));
                map.from(() -> ((SessionCookieConfig)cookie).isSecure()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseSecureCookie(arg_0));
                map.from(() -> ((SessionCookieConfig)cookie).getMaxAge()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieMaxAge(arg_0));
                map.from((Object)cookie.getAttribute("SameSite")).always().to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setSameSite(arg_0));
                map.from((Object)cookie.getAttribute("Partitioned")).as(Boolean::valueOf).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setPartitioned(arg_0));
                cookieSerializerCustomizers.orderedStream().forEach(customizer -> customizer.customize(cookieSerializer));
                return cookieSerializer;
            }
        }

        @ConditionalOnNotWarDeployment
        @EnableConfigurationProperties(value={ServerProperties.class})
        static class EmbeddedWebServerConfiguration {
            EmbeddedWebServerConfiguration() {
            }

            @Bean
            SessionTimeout embeddedWebServerSessionTimeout(SessionProperties sessionProperties, ServerProperties serverProperties) {
                return () -> SessionAutoConfiguration.determineTimeout(sessionProperties, () -> ((org.springframework.boot.web.server.servlet.Session)serverProperties.getServlet().getSession()).getTimeout());
            }

            @Bean
            @Conditional(value={DefaultCookieSerializerCondition.class})
            DefaultCookieSerializer cookieSerializer(ServerProperties serverProperties, ObjectProvider<DefaultCookieSerializerCustomizer> cookieSerializerCustomizers) {
                Cookie cookie = serverProperties.getServlet().getSession().getCookie();
                DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
                PropertyMapper map = PropertyMapper.get();
                map.from(() -> ((Cookie)cookie).getName()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieName(arg_0));
                map.from(() -> ((Cookie)cookie).getDomain()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setDomainName(arg_0));
                map.from(() -> ((Cookie)cookie).getPath()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookiePath(arg_0));
                map.from(() -> ((Cookie)cookie).getHttpOnly()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseHttpOnlyCookie(arg_0));
                map.from(() -> ((Cookie)cookie).getSecure()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseSecureCookie(arg_0));
                map.from(() -> ((Cookie)cookie).getMaxAge()).asInt(Duration::getSeconds).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieMaxAge(arg_0));
                map.from(() -> ((Cookie)cookie).getSameSite()).as(Cookie.SameSite::attributeValue).always().to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setSameSite(arg_0));
                map.from(() -> ((Cookie)cookie).getPartitioned()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setPartitioned(arg_0));
                cookieSerializerCustomizers.orderedStream().forEach(customizer -> customizer.customize(cookieSerializer));
                return cookieSerializer;
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={RememberMeServices.class})
        static class RememberMeServicesConfiguration {
            RememberMeServicesConfiguration() {
            }

            @Bean
            DefaultCookieSerializerCustomizer rememberMeServicesCookieSerializerCustomizer() {
                return cookieSerializer -> cookieSerializer.setRememberMeRequestAttribute(SpringSessionRememberMeServices.REMEMBER_ME_LOGIN_ATTR);
            }
        }
    }
}

