/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import io.micrometer.tracing.otel.bridge.CompositeSpanExporter;
import io.micrometer.tracing.otel.bridge.EventListener;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelPropagator;
import io.micrometer.tracing.otel.bridge.OtelSpanCustomizer;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.micrometer.tracing.otel.bridge.Slf4JEventListener;
import io.micrometer.tracing.propagation.Propagator;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.tracing.autoconfigure.MicrometerTracingAutoConfiguration;
import org.springframework.boot.micrometer.tracing.autoconfigure.NoopTracerAutoConfiguration;
import org.springframework.boot.micrometer.tracing.autoconfigure.TracingProperties;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.OpenTelemetryPropagationConfigurations;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.OpenTelemetryTracingProperties;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.SdkTracerProviderBuilderCustomizer;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.SpanExporters;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.SpanProcessors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(before={MicrometerTracingAutoConfiguration.class, NoopTracerAutoConfiguration.class})
@ConditionalOnClass(value={OtelTracer.class, SdkTracerProvider.class, OpenTelemetry.class})
@EnableConfigurationProperties(value={TracingProperties.class, OpenTelemetryTracingProperties.class})
@Import(value={OpenTelemetryPropagationConfigurations.PropagationWithoutBaggage.class, OpenTelemetryPropagationConfigurations.PropagationWithBaggage.class, OpenTelemetryPropagationConfigurations.NoPropagation.class})
public final class OpenTelemetryTracingAutoConfiguration {
    private static final Log logger = LogFactory.getLog(OpenTelemetryTracingAutoConfiguration.class);
    private final TracingProperties tracingProperties;
    private final OpenTelemetryTracingProperties openTelemetryTracingProperties;

    OpenTelemetryTracingAutoConfiguration(TracingProperties tracingProperties, OpenTelemetryTracingProperties openTelemetryTracingProperties) {
        this.tracingProperties = tracingProperties;
        if (!CollectionUtils.isEmpty((Collection)this.tracingProperties.getBaggage().getLocalFields())) {
            logger.warn((Object)"Local fields are not supported when using OpenTelemetry!");
        }
        this.openTelemetryTracingProperties = openTelemetryTracingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    SdkTracerProvider otelSdkTracerProvider(Resource resource, SpanProcessors spanProcessors, Sampler sampler, ObjectProvider<SdkTracerProviderBuilderCustomizer> customizers) {
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setSampler(sampler).setResource(resource);
        spanProcessors.forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    ContextPropagators otelContextPropagators(ObjectProvider<TextMapPropagator> textMapPropagators) {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators.orderedStream().toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler otelSampler() {
        Sampler rootSampler = Sampler.traceIdRatioBased((double)this.tracingProperties.getSampling().getProbability());
        return Sampler.parentBased((Sampler)rootSampler);
    }

    @Bean
    @ConditionalOnMissingBean
    SpanProcessors spanProcessors(ObjectProvider<SpanProcessor> spanProcessors) {
        return SpanProcessors.of(spanProcessors.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    BatchSpanProcessor otelSpanProcessor(SpanExporters spanExporters, ObjectProvider<SpanExportingPredicate> spanExportingPredicates, ObjectProvider<SpanReporter> spanReporters, ObjectProvider<SpanFilter> spanFilters, ObjectProvider<MeterProvider> meterProvider) {
        OpenTelemetryTracingProperties.Export properties = this.openTelemetryTracingProperties.getExport();
        CompositeSpanExporter spanExporter = new CompositeSpanExporter(spanExporters.list(), spanExportingPredicates.orderedStream().toList(), spanReporters.orderedStream().toList(), spanFilters.orderedStream().toList());
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder((SpanExporter)spanExporter).setExportUnsampledSpans(properties.isIncludeUnsampled()).setExporterTimeout(properties.getTimeout()).setMaxExportBatchSize(properties.getMaxBatchSize()).setMaxQueueSize(properties.getMaxQueueSize()).setScheduleDelay(properties.getScheduleDelay());
        meterProvider.ifAvailable(arg_0 -> ((BatchSpanProcessorBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    SpanExporters spanExporters(ObjectProvider<SpanExporter> spanExporters) {
        return SpanExporters.of(spanExporters.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    io.opentelemetry.api.trace.Tracer otelTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer("org.springframework.boot", SpringBootVersion.getVersion());
    }

    @Bean
    @ConditionalOnMissingBean(value={Tracer.class})
    OtelTracer micrometerOtelTracer(io.opentelemetry.api.trace.Tracer tracer, OtelTracer.EventPublisher eventPublisher, OtelCurrentTraceContext otelCurrentTraceContext) {
        List remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
        List tagFields = this.tracingProperties.getBaggage().getTagFields();
        return new OtelTracer(tracer, otelCurrentTraceContext, eventPublisher, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, remoteFields, tagFields));
    }

    @Bean
    @ConditionalOnMissingBean(value={Propagator.class})
    OtelPropagator otelPropagator(ContextPropagators contextPropagators, io.opentelemetry.api.trace.Tracer tracer) {
        return new OtelPropagator(contextPropagators, tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    OtelTracer.EventPublisher otelTracerEventPublisher(List<EventListener> eventListeners) {
        return new OTelEventPublisher(eventListeners);
    }

    @Bean
    @ConditionalOnMissingBean
    OtelCurrentTraceContext otelCurrentTraceContext() {
        return new OtelCurrentTraceContext();
    }

    @Bean
    @ConditionalOnMissingBean
    Slf4JEventListener otelSlf4JEventListener() {
        return new Slf4JEventListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanCustomizer.class})
    OtelSpanCustomizer otelSpanCustomizer() {
        return new OtelSpanCustomizer();
    }

    static class OTelEventPublisher
    implements OtelTracer.EventPublisher {
        private final List<EventListener> listeners;

        OTelEventPublisher(List<EventListener> listeners) {
            this.listeners = listeners;
        }

        public void publishEvent(Object event) {
            for (EventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }
}

