/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.springframework.util.StringUtils;

class MavenBuildOutputTimestamp {
    private static final Instant DATE_MIN = Instant.parse("1980-01-01T00:00:02Z");
    private static final Instant DATE_MAX = Instant.parse("2099-12-31T23:59:59Z");
    private final String timestamp;

    MavenBuildOutputTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    FileTime toFileTime() {
        Instant instant = this.toInstant();
        if (instant == null) {
            return null;
        }
        return FileTime.from(instant);
    }

    Instant toInstant() {
        if (!StringUtils.hasLength((String)this.timestamp)) {
            return null;
        }
        if (MavenBuildOutputTimestamp.isNumeric(this.timestamp)) {
            return Instant.ofEpochSecond(Long.parseLong(this.timestamp));
        }
        if (this.timestamp.length() < 2) {
            return null;
        }
        try {
            Instant instant = OffsetDateTime.parse(this.timestamp).withOffsetSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).toInstant();
            if (instant.isBefore(DATE_MIN) || instant.isAfter(DATE_MAX)) {
                throw new IllegalArgumentException(String.format(String.format("'%s' is not within the valid range %s to %s", instant, DATE_MIN, DATE_MAX), new Object[0]));
            }
            return instant;
        }
        catch (DateTimeParseException pe) {
            throw new IllegalArgumentException(String.format("Can't parse '%s' to instant", this.timestamp));
        }
    }

    private static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

