/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class EnvVariables {
    private final Map<String, String> variables;

    EnvVariables(Map<String, String> variables) {
        this.variables = EnvVariables.parseEnvVariables(variables);
    }

    private static Map<String, String> parseEnvVariables(Map<String, String> args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : args.entrySet()) {
            if (e.getKey() == null) continue;
            result.put(e.getKey(), EnvVariables.getValue(e.getValue()));
        }
        return result;
    }

    private static String getValue(String value) {
        return value != null ? value : "";
    }

    Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.variables);
    }

    String[] asArray() {
        ArrayList<String> args = new ArrayList<String>(this.variables.size());
        for (Map.Entry<String, String> arg : this.variables.entrySet()) {
            args.add(arg.getKey() + "=" + arg.getValue());
        }
        return args.toArray(new String[0]);
    }
}

