/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jms.autoconfigure.AcknowledgeMode;

@ConfigurationProperties(value="spring.jms")
public class JmsProperties {
    private boolean pubSubDomain;
    private @Nullable String jndiName;
    private boolean subscriptionDurable;
    private @Nullable String clientId;
    private final Cache cache = new Cache();
    private final Listener listener = new Listener();
    private final Template template = new Template();

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public @Nullable String getClientId() {
        return this.clientId;
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    public @Nullable String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(@Nullable String jndiName) {
        this.jndiName = jndiName;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Template getTemplate() {
        return this.template;
    }

    public static class Cache {
        private boolean enabled = true;
        private boolean consumers;
        private boolean producers = true;
        private int sessionCacheSize = 1;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isConsumers() {
            return this.consumers;
        }

        public void setConsumers(boolean consumers) {
            this.consumers = consumers;
        }

        public boolean isProducers() {
            return this.producers;
        }

        public void setProducers(boolean producers) {
            this.producers = producers;
        }

        public int getSessionCacheSize() {
            return this.sessionCacheSize;
        }

        public void setSessionCacheSize(int sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
        }
    }

    public static class Listener {
        private boolean autoStartup = true;
        private @Nullable Integer minConcurrency;
        private @Nullable Integer maxConcurrency;
        private Duration receiveTimeout = Duration.ofSeconds(1L);
        private @Nullable Integer maxMessagesPerTask;
        private final Session session = new Session();

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public @Nullable Integer getMinConcurrency() {
            return this.minConcurrency;
        }

        public void setMinConcurrency(@Nullable Integer minConcurrency) {
            this.minConcurrency = minConcurrency;
        }

        public @Nullable Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public void setMaxConcurrency(@Nullable Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public @Nullable String formatConcurrency() {
            if (this.minConcurrency == null) {
                return this.maxConcurrency != null ? "1-" + this.maxConcurrency : null;
            }
            return this.minConcurrency + "-" + (this.maxConcurrency != null ? this.maxConcurrency : this.minConcurrency);
        }

        public Duration getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public @Nullable Integer getMaxMessagesPerTask() {
            return this.maxMessagesPerTask;
        }

        public void setMaxMessagesPerTask(@Nullable Integer maxMessagesPerTask) {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }

        public Session getSession() {
            return this.session;
        }

        public static class Session {
            private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
            private @Nullable Boolean transacted;

            public AcknowledgeMode getAcknowledgeMode() {
                return this.acknowledgeMode;
            }

            public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
                this.acknowledgeMode = acknowledgeMode;
            }

            public @Nullable Boolean getTransacted() {
                return this.transacted;
            }

            public void setTransacted(@Nullable Boolean transacted) {
                this.transacted = transacted;
            }
        }
    }

    public static class Template {
        private @Nullable String defaultDestination;
        private @Nullable Duration deliveryDelay;
        private @Nullable DeliveryMode deliveryMode;
        private @Nullable Integer priority;
        private @Nullable Duration timeToLive;
        private @Nullable Boolean qosEnabled;
        private @Nullable Duration receiveTimeout;
        private final Session session = new Session();

        public @Nullable String getDefaultDestination() {
            return this.defaultDestination;
        }

        public void setDefaultDestination(@Nullable String defaultDestination) {
            this.defaultDestination = defaultDestination;
        }

        public @Nullable Duration getDeliveryDelay() {
            return this.deliveryDelay;
        }

        public void setDeliveryDelay(@Nullable Duration deliveryDelay) {
            this.deliveryDelay = deliveryDelay;
        }

        public @Nullable DeliveryMode getDeliveryMode() {
            return this.deliveryMode;
        }

        public void setDeliveryMode(@Nullable DeliveryMode deliveryMode) {
            this.deliveryMode = deliveryMode;
        }

        public @Nullable Integer getPriority() {
            return this.priority;
        }

        public void setPriority(@Nullable Integer priority) {
            this.priority = priority;
        }

        public @Nullable Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(@Nullable Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public boolean determineQosEnabled() {
            if (this.qosEnabled != null) {
                return this.qosEnabled;
            }
            return this.getDeliveryMode() != null || this.getPriority() != null || this.getTimeToLive() != null;
        }

        public @Nullable Boolean getQosEnabled() {
            return this.qosEnabled;
        }

        public void setQosEnabled(@Nullable Boolean qosEnabled) {
            this.qosEnabled = qosEnabled;
        }

        public @Nullable Duration getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(@Nullable Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public Session getSession() {
            return this.session;
        }

        public static class Session {
            private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
            private boolean transacted;

            public AcknowledgeMode getAcknowledgeMode() {
                return this.acknowledgeMode;
            }

            public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
                this.acknowledgeMode = acknowledgeMode;
            }

            public boolean isTransacted() {
                return this.transacted;
            }

            public void setTransacted(boolean transacted) {
                this.transacted = transacted;
            }
        }
    }

    public static enum DeliveryMode {
        NON_PERSISTENT(1),
        PERSISTENT(2);

        private final int value;

        private DeliveryMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

