/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletRequest;
import java.util.EnumSet;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.ee11.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.ee11.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWarDeployment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.autoconfigure.JettyWebServerConfiguration;
import org.springframework.boot.jetty.autoconfigure.servlet.WebSocketJettyServletWebServerFactoryCustomizer;
import org.springframework.boot.jetty.servlet.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.servlet.ServletWebServerConfiguration;
import org.springframework.boot.web.server.servlet.ServletWebServerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnClass(value={ServletRequest.class, Server.class, Loader.class, WebAppContext.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={JettyServerProperties.class})
@Import(value={JettyWebServerConfiguration.class, ServletWebServerConfiguration.class})
public final class JettyServletWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    JettyServletWebServerFactory jettyServletWebServerFactory(ObjectProvider<JettyServerCustomizer> serverCustomizers) {
        JettyServletWebServerFactory factory = new JettyServletWebServerFactory();
        factory.getServerCustomizers().addAll(serverCustomizers.orderedStream().toList());
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JakartaWebSocketServletContainerInitializer.class})
    static class JettyWebSocketConfiguration {
        JettyWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketServletWebServerCustomizer"})
        WebSocketJettyServletWebServerFactoryCustomizer websocketServletWebServerCustomizer() {
            return new WebSocketJettyServletWebServerFactoryCustomizer();
        }

        @Bean
        @ConditionalOnNotWarDeployment
        @Order(value=0x7FFFFFFF)
        @ConditionalOnMissingBean(name={"websocketUpgradeFilterWebServerCustomizer"})
        WebServerFactoryCustomizer<JettyServletWebServerFactory> websocketUpgradeFilterWebServerCustomizer() {
            return factory -> factory.addInitializers(new ServletContextInitializer[]{servletContext -> {
                FilterRegistration.Dynamic registration = servletContext.addFilter(WebSocketUpgradeFilter.class.getName(), (Filter)new WebSocketUpgradeFilter());
                registration.setAsyncSupported(true);
                registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
            }});
        }
    }
}

