/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.imperative;

import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.JdkClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.autoconfigure.ClientHttpRequestFactoryBuilderCustomizer;
import org.springframework.boot.http.client.autoconfigure.HttpClientAutoConfiguration;
import org.springframework.boot.http.client.autoconfigure.imperative.ImperativeHttpClientsProperties;
import org.springframework.boot.http.client.autoconfigure.imperative.NotReactiveWebApplicationCondition;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.http.client.ClientHttpRequestFactory;

@AutoConfiguration(after={HttpClientAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpRequestFactory.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={ImperativeHttpClientsProperties.class})
public final class ImperativeHttpClientAutoConfiguration {
    private final Environment environment;

    ImperativeHttpClientAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder(ResourceLoader resourceLoader, ImperativeHttpClientsProperties properties, ObjectProvider<ClientHttpRequestFactoryBuilderCustomizer<?>> clientHttpRequestFactoryBuilderCustomizers) {
        JdkClientHttpRequestFactoryBuilder builder;
        JdkClientHttpRequestFactoryBuilder jdkClientHttpRequestFactoryBuilder = builder = properties.getFactory() != null ? properties.getFactory().builder() : ClientHttpRequestFactoryBuilder.detect(resourceLoader.getClassLoader());
        if (builder instanceof JdkClientHttpRequestFactoryBuilder) {
            JdkClientHttpRequestFactoryBuilder jdk = builder;
            if (Threading.VIRTUAL.isActive(this.environment)) {
                builder = jdk.withExecutor((Executor)new VirtualThreadTaskExecutor("httpclient-"));
            }
        }
        return this.customize(builder, clientHttpRequestFactoryBuilderCustomizers.orderedStream().toList());
    }

    private ClientHttpRequestFactoryBuilder<?> customize(ClientHttpRequestFactoryBuilder<?> builder, List<ClientHttpRequestFactoryBuilderCustomizer<?>> customizers) {
        ClientHttpRequestFactoryBuilder[] builderReference = new ClientHttpRequestFactoryBuilder[]{builder};
        LambdaSafe.callbacks(ClientHttpRequestFactoryBuilderCustomizer.class, customizers, (Object)builderReference[0], (Object[])new Object[0]).invoke(customizer -> {
            builderReference[0] = customizer.customize(builderReference[0]);
        });
        return builderReference[0];
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    ClientHttpRequestFactory clientHttpRequestFactory(ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder, HttpClientSettings httpClientSettings) {
        return clientHttpRequestFactoryBuilder.build(httpClientSettings);
    }
}

