/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.actuate.endpoint;

import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.actuate.endpoint.HealthDescriptor;
import org.springframework.boot.health.actuate.endpoint.IndicatedHealthDescriptor;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface Contributor<H, D>
extends Iterable<Child<H, D>> {
    public boolean isComposite();

    public @Nullable Contributor<H, D> getChild(String var1);

    public @Nullable D getDescriptor(boolean var1);

    default public String getIdentifier(String name) {
        String className = this.getContributorClassName();
        return !StringUtils.hasLength((String)name) ? className : className + " (" + name + ")";
    }

    public String getContributorClassName();

    public static Blocking blocking(HealthContributorRegistry registry, @Nullable ReactiveHealthContributorRegistry fallbackRegistry) {
        return new Blocking(fallbackRegistry != null ? HealthContributors.of(registry, fallbackRegistry.asHealthContributors()) : registry);
    }

    public static Reactive reactive(ReactiveHealthContributorRegistry registry, @Nullable HealthContributorRegistry fallbackRegistry) {
        return new Reactive(fallbackRegistry != null ? ReactiveHealthContributors.of(registry, ReactiveHealthContributors.adapt(fallbackRegistry)) : registry);
    }

    public record Blocking(Object contributor) implements Contributor<Health, HealthDescriptor>
    {
        @Override
        public boolean isComposite() {
            return this.contributor() instanceof HealthContributors;
        }

        public @Nullable Blocking getChild(String name) {
            HealthContributor child = ((HealthContributors)this.contributor()).getContributor(name);
            return child != null ? new Blocking(child) : null;
        }

        @Override
        public Iterator<Child<Health, HealthDescriptor>> iterator() {
            return ((HealthContributors)this.contributor()).stream().map(entry -> new Child<Health, HealthDescriptor>(entry.name(), new Blocking(entry.contributor()))).iterator();
        }

        @Override
        public @Nullable HealthDescriptor getDescriptor(boolean includeDetails) {
            Health health = ((HealthIndicator)this.contributor()).health(includeDetails);
            return health != null ? new IndicatedHealthDescriptor(health) : null;
        }

        @Override
        public String getContributorClassName() {
            return this.contributor().getClass().getName();
        }
    }

    public record Reactive(Object contributor) implements Contributor<Mono<? extends Health>, Mono<? extends HealthDescriptor>>
    {
        @Override
        public boolean isComposite() {
            return this.contributor() instanceof ReactiveHealthContributors;
        }

        public @Nullable Reactive getChild(String name) {
            ReactiveHealthContributor child = ((ReactiveHealthContributors)this.contributor()).getContributor(name);
            return child != null ? new Reactive(child) : null;
        }

        @Override
        public Iterator<Child<Mono<? extends Health>, Mono<? extends HealthDescriptor>>> iterator() {
            return ((ReactiveHealthContributors)this.contributor()).stream().map(entry -> new Child<Mono<? extends Health>, Mono<? extends HealthDescriptor>>(entry.name(), new Reactive(entry.contributor()))).iterator();
        }

        @Override
        public Mono<? extends HealthDescriptor> getDescriptor(boolean includeDetails) {
            Mono<Health> health = ((ReactiveHealthIndicator)this.contributor).health(includeDetails);
            return health.map(IndicatedHealthDescriptor::new);
        }

        @Override
        public String getContributorClassName() {
            return this.contributor().getClass().getName();
        }
    }

    public record Child<H, D>(String name, Contributor<H, D> contributor) {
    }
}

