/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;

class LoaderZipEntries {
    private Long entryTime;

    LoaderZipEntries(Long entryTime) {
        this.entryTime = entryTime;
    }

    public Spec<FileTreeElement> writeTo(ZipArchiveOutputStream zipOutputStream) throws IOException {
        WrittenDirectoriesSpec writtenDirectoriesSpec = new WrittenDirectoriesSpec();
        try (ZipInputStream loaderJar = new ZipInputStream(this.getClass().getResourceAsStream("/META-INF/loader/spring-boot-loader.jar"));){
            ZipEntry entry = loaderJar.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory() && !entry.getName().equals("META-INF/")) {
                    this.writeDirectory(new ZipArchiveEntry(entry), zipOutputStream);
                    writtenDirectoriesSpec.add(entry);
                } else if (entry.getName().endsWith(".class")) {
                    this.writeClass(new ZipArchiveEntry(entry), loaderJar, zipOutputStream);
                }
                entry = loaderJar.getNextEntry();
            }
        }
        return writtenDirectoriesSpec;
    }

    private void writeDirectory(ZipArchiveEntry entry, ZipArchiveOutputStream out) throws IOException {
        this.prepareEntry(entry, 16877);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.closeArchiveEntry();
    }

    private void writeClass(ZipArchiveEntry entry, ZipInputStream in, ZipArchiveOutputStream out) throws IOException {
        this.prepareEntry(entry, 33188);
        out.putArchiveEntry((ArchiveEntry)entry);
        this.copy(in, (OutputStream)out);
        out.closeArchiveEntry();
    }

    private void prepareEntry(ZipArchiveEntry entry, int unixMode) {
        if (this.entryTime != null) {
            entry.setTime(this.entryTime.longValue());
        }
        entry.setUnixMode(unixMode);
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private static class WrittenDirectoriesSpec
    implements Spec<FileTreeElement> {
        private final Set<String> entries = new HashSet<String>();

        private WrittenDirectoriesSpec() {
        }

        public boolean isSatisfiedBy(FileTreeElement element) {
            String path = element.getRelativePath().getPathString();
            if (element.isDirectory() && !path.endsWith("/")) {
                path = path + "/";
            }
            return this.entries.contains(path);
        }

        public void add(ZipEntry entry) {
            this.entries.add(entry.getName());
        }
    }
}

