/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure.observation;

import io.lettuce.core.RedisClient;
import io.lettuce.core.tracing.MicrometerTracing;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.data.redis.autoconfigure.ClientResourcesBuilderCustomizer;
import org.springframework.boot.data.redis.autoconfigure.DataRedisAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={DataRedisAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnClass(value={RedisClient.class, MicrometerTracing.class, ObservationRegistry.class})
@ConditionalOnBean(value={ObservationRegistry.class})
public final class LettuceObservationAutoConfiguration {
    @Bean
    ClientResourcesBuilderCustomizer lettuceObservation(ObservationRegistry observationRegistry) {
        return client -> client.tracing((Tracing)new MicrometerTracing(observationRegistry, "Redis"));
    }
}

