/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisUrl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertiesDataRedisConnectionDetails
implements DataRedisConnectionDetails {
    private final DataRedisProperties properties;
    private final @Nullable SslBundles sslBundles;

    PropertiesDataRedisConnectionDetails(DataRedisProperties properties, @Nullable SslBundles sslBundles) {
        this.properties = properties;
        this.sslBundles = sslBundles;
    }

    @Override
    public @Nullable String getUsername() {
        DataRedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? redisUrl.credentials().username() : this.properties.getUsername();
    }

    @Override
    public @Nullable String getPassword() {
        DataRedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? redisUrl.credentials().password() : this.properties.getPassword();
    }

    @Override
    public @Nullable SslBundle getSslBundle() {
        if (!this.properties.getSsl().isEnabled()) {
            return null;
        }
        String bundleName = this.properties.getSsl().getBundle();
        if (StringUtils.hasLength((String)bundleName)) {
            Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
            return this.sslBundles.getBundle(bundleName);
        }
        return SslBundle.systemDefault();
    }

    @Override
    public DataRedisConnectionDetails.Standalone getStandalone() {
        DataRedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? DataRedisConnectionDetails.Standalone.of(redisUrl.uri().getHost(), redisUrl.uri().getPort(), redisUrl.database()) : DataRedisConnectionDetails.Standalone.of(this.properties.getHost(), this.properties.getPort(), this.properties.getDatabase());
    }

    @Override
    public @Nullable DataRedisConnectionDetails.Sentinel getSentinel() {
        DataRedisProperties.Sentinel sentinel = this.properties.getSentinel();
        return sentinel != null ? new PropertiesSentinel(this.getStandalone().getDatabase(), sentinel) : null;
    }

    @Override
    public @Nullable DataRedisConnectionDetails.Cluster getCluster() {
        DataRedisProperties.Cluster cluster = this.properties.getCluster();
        return cluster != null ? new PropertiesCluster(cluster) : null;
    }

    @Override
    public @Nullable DataRedisConnectionDetails.MasterReplica getMasterReplica() {
        DataRedisProperties.Masterreplica masterreplica = this.properties.getMasterreplica();
        return masterreplica != null ? new PropertiesMasterReplica(masterreplica) : null;
    }

    private @Nullable DataRedisUrl getRedisUrl() {
        return DataRedisUrl.of(this.properties.getUrl());
    }

    private List<DataRedisConnectionDetails.Node> asNodes(@Nullable List<String> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return nodes.stream().map(this::asNode).toList();
    }

    private DataRedisConnectionDetails.Node asNode(String node) {
        int portSeparatorIndex = node.lastIndexOf(58);
        String host = node.substring(0, portSeparatorIndex);
        int port = Integer.parseInt(node.substring(portSeparatorIndex + 1));
        return new DataRedisConnectionDetails.Node(host, port);
    }

    private class PropertiesSentinel
    implements DataRedisConnectionDetails.Sentinel {
        private final int database;
        private final DataRedisProperties.Sentinel properties;

        PropertiesSentinel(int database, DataRedisProperties.Sentinel properties) {
            this.database = database;
            this.properties = properties;
        }

        @Override
        public int getDatabase() {
            return this.database;
        }

        @Override
        public String getMaster() {
            String master = this.properties.getMaster();
            Assert.state((master != null ? 1 : 0) != 0, (String)"'master' must not be null");
            return master;
        }

        @Override
        public List<DataRedisConnectionDetails.Node> getNodes() {
            return PropertiesDataRedisConnectionDetails.this.asNodes(this.properties.getNodes());
        }

        @Override
        public @Nullable String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public @Nullable String getPassword() {
            return this.properties.getPassword();
        }
    }

    private class PropertiesCluster
    implements DataRedisConnectionDetails.Cluster {
        private final List<DataRedisConnectionDetails.Node> nodes;

        PropertiesCluster(DataRedisProperties.Cluster properties) {
            this.nodes = PropertiesDataRedisConnectionDetails.this.asNodes(properties.getNodes());
        }

        @Override
        public List<DataRedisConnectionDetails.Node> getNodes() {
            return this.nodes;
        }
    }

    private class PropertiesMasterReplica
    implements DataRedisConnectionDetails.MasterReplica {
        private final List<DataRedisConnectionDetails.Node> nodes;

        PropertiesMasterReplica(DataRedisProperties.Masterreplica properties) {
            this.nodes = PropertiesDataRedisConnectionDetails.this.asNodes(properties.getNodes());
        }

        @Override
        public List<DataRedisConnectionDetails.Node> getNodes() {
            return this.nodes;
        }
    }
}

