/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cassandra.autoconfigure;

import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.cassandra")
public class CassandraProperties {
    private @Nullable Resource config;
    private @Nullable String keyspaceName;
    private @Nullable String sessionName;
    private @Nullable List<String> contactPoints;
    private int port = 9042;
    private @Nullable String localDatacenter;
    private @Nullable String username;
    private @Nullable String password;
    private @Nullable Compression compression;
    private String schemaAction = "none";
    private Ssl ssl = new Ssl();
    private final Connection connection = new Connection();
    private final Pool pool = new Pool();
    private final Request request = new Request();
    private final Controlconnection controlconnection = new Controlconnection();

    public @Nullable Resource getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable Resource config) {
        this.config = config;
    }

    public @Nullable String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(@Nullable String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public @Nullable String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(@Nullable String sessionName) {
        this.sessionName = sessionName;
    }

    public @Nullable List<String> getContactPoints() {
        return this.contactPoints;
    }

    public void setContactPoints(@Nullable List<String> contactPoints) {
        this.contactPoints = contactPoints;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public @Nullable String getLocalDatacenter() {
        return this.localDatacenter;
    }

    public void setLocalDatacenter(@Nullable String localDatacenter) {
        this.localDatacenter = localDatacenter;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public @Nullable Compression getCompression() {
        return this.compression;
    }

    public void setCompression(@Nullable Compression compression) {
        this.compression = compression;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public String getSchemaAction() {
        return this.schemaAction;
    }

    public void setSchemaAction(String schemaAction) {
        this.schemaAction = schemaAction;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Request getRequest() {
        return this.request;
    }

    public Controlconnection getControlconnection() {
        return this.controlconnection;
    }

    public static class Ssl {
        private @Nullable Boolean enabled;
        private @Nullable String bundle;

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled : this.bundle != null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }
    }

    public static class Connection {
        private @Nullable Duration connectTimeout;
        private @Nullable Duration initQueryTimeout;

        public @Nullable Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public @Nullable Duration getInitQueryTimeout() {
            return this.initQueryTimeout;
        }

        public void setInitQueryTimeout(@Nullable Duration initQueryTimeout) {
            this.initQueryTimeout = initQueryTimeout;
        }
    }

    public static class Pool {
        private @Nullable Duration idleTimeout;
        private @Nullable Duration heartbeatInterval;

        public @Nullable Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(@Nullable Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public @Nullable Duration getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(@Nullable Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }
    }

    public static class Request {
        private @Nullable Duration timeout;
        private @Nullable DefaultConsistencyLevel consistency;
        private @Nullable DefaultConsistencyLevel serialConsistency;
        private @Nullable Integer pageSize;
        private final Throttler throttler = new Throttler();

        public @Nullable Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
        }

        public @Nullable DefaultConsistencyLevel getConsistency() {
            return this.consistency;
        }

        public void setConsistency(@Nullable DefaultConsistencyLevel consistency) {
            this.consistency = consistency;
        }

        public @Nullable DefaultConsistencyLevel getSerialConsistency() {
            return this.serialConsistency;
        }

        public void setSerialConsistency(@Nullable DefaultConsistencyLevel serialConsistency) {
            this.serialConsistency = serialConsistency;
        }

        public @Nullable Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Throttler getThrottler() {
            return this.throttler;
        }
    }

    public static class Controlconnection {
        private @Nullable Duration timeout;

        public @Nullable Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static enum Compression {
        LZ4,
        SNAPPY,
        NONE;

    }

    public static enum ThrottlerType {
        CONCURRENCY_LIMITING("ConcurrencyLimitingRequestThrottler"),
        RATE_LIMITING("RateLimitingRequestThrottler"),
        NONE("PassThroughRequestThrottler");

        private final String type;

        private ThrottlerType(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }

    public static class Throttler {
        private @Nullable ThrottlerType type;
        private @Nullable Integer maxQueueSize;
        private @Nullable Integer maxConcurrentRequests;
        private @Nullable Integer maxRequestsPerSecond;
        private @Nullable Duration drainInterval;

        public @Nullable ThrottlerType getType() {
            return this.type;
        }

        public void setType(@Nullable ThrottlerType type) {
            this.type = type;
        }

        public @Nullable Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(@Nullable Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public @Nullable Integer getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(@Nullable Integer maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }

        public @Nullable Integer getMaxRequestsPerSecond() {
            return this.maxRequestsPerSecond;
        }

        public void setMaxRequestsPerSecond(@Nullable Integer maxRequestsPerSecond) {
            this.maxRequestsPerSecond = maxRequestsPerSecond;
        }

        public @Nullable Duration getDrainInterval() {
            return this.drainInterval;
        }

        public void setDrainInterval(@Nullable Duration drainInterval) {
            this.drainInterval = drainInterval;
        }
    }
}

