/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import org.springframework.amqp.AmqpRemoteException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.RemoteInvocationResult;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

public class RemoteInvocationAwareMessageConverterAdapter
implements MessageConverter {
    private final MessageConverter delegate;

    public RemoteInvocationAwareMessageConverterAdapter() {
        this.delegate = new SimpleMessageConverter();
    }

    public RemoteInvocationAwareMessageConverterAdapter(MessageConverter delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' converter cannot be null");
        this.delegate = delegate;
    }

    @Override
    public Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        return this.delegate.toMessage(object, messageProperties);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object result = this.delegate.fromMessage(message);
        if (result instanceof RemoteInvocationResult) {
            RemoteInvocationResult remoteInvocationResult = (RemoteInvocationResult)result;
            try {
                result = remoteInvocationResult.recreate();
                if (result == null) {
                    throw new MessageConversionException("RemoteInvocationResult returned null");
                }
            }
            catch (Throwable e) {
                throw new AmqpRemoteException(e);
            }
        }
        return result;
    }
}

